/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class CpioTestCase
extends AbstractTestCase {
    @Test
    public void testCpioArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.cpio");
        File file1 = CpioTestCase.getFile("test1.xml");
        File file2 = CpioTestCase.getFile("test2.xml");
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("cpio", (OutputStream)out);
        os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        ((OutputStream)out).close();
    }

    @Test
    public void testCpioUnarchive() throws Exception {
        File output = new File(this.dir, "bla.cpio");
        File file1 = CpioTestCase.getFile("test1.xml");
        File file2 = CpioTestCase.getFile("test2.xml");
        long file1Length = file1.length();
        long file2Length = file2.length();
        FileOutputStream out = new FileOutputStream(output);
        ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("cpio", (OutputStream)out);
        CpioArchiveEntry entry = new CpioArchiveEntry("test1.xml", file1Length);
        entry.setMode(32768L);
        os.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
        os.closeArchiveEntry();
        entry = new CpioArchiveEntry("test2.xml", file2Length);
        entry.setMode(32768L);
        os.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
        os.closeArchiveEntry();
        os.finish();
        os.close();
        ((OutputStream)out).close();
        File input = output;
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("cpio", (InputStream)is);
        HashMap<String, File> result = new HashMap<String, File>();
        ArchiveEntry entry2 = null;
        while ((entry2 = in.getNextEntry()) != null) {
            File cpioget = new File(this.dir, entry2.getName());
            FileOutputStream out2 = new FileOutputStream(cpioget);
            IOUtils.copy((InputStream)in, (OutputStream)out2);
            ((OutputStream)out2).close();
            result.put(entry2.getName(), cpioget);
        }
        in.close();
        ((InputStream)is).close();
        File t = (File)result.get("test1.xml");
        Assert.assertTrue((String)("Expected " + t.getAbsolutePath() + " to exist"), (boolean)t.exists());
        Assert.assertEquals((String)("length of " + t.getAbsolutePath()), (long)file1Length, (long)t.length());
        t = (File)result.get("test2.xml");
        Assert.assertTrue((String)("Expected " + t.getAbsolutePath() + " to exist"), (boolean)t.exists());
        Assert.assertEquals((String)("length of " + t.getAbsolutePath()), (long)file2Length, (long)t.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            CpioArchiveEntry in = new CpioArchiveEntry(tmp[0], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream((InputStream)new FileInputStream(archive));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            long beforeArchiveWrite = tmp[0].lastModified();
            CpioArchiveEntry in = new CpioArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite / 1000L);
            in.setMode(16384L);
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream((InputStream)new FileInputStream(archive));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            CpioArchiveEntry in = new CpioArchiveEntry(tmp[1], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream((InputStream)new FileInputStream(archive));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream((OutputStream)new FileOutputStream(archive));
            CpioArchiveEntry in = new CpioArchiveEntry("foo");
            in.setTime(tmp[1].lastModified() / 1000L);
            in.setSize(tmp[1].length());
            in.setMode(32768L);
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream((InputStream)new FileInputStream(archive));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }
}

