/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionMessageTest {
    private static final String ARCHIVER_NULL_MESSAGE = "Archivername must not be null.";
    private static final String INPUTSTREAM_NULL_MESSAGE = "InputStream must not be null.";
    private static final String OUTPUTSTREAM_NULL_MESSAGE = "OutputStream must not be null.";

    @Test
    public void testMessageWhenArchiverNameIsNull_1() {
        try {
            new ArchiveStreamFactory().createArchiveInputStream(null, System.in);
            Assert.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            Assert.fail((String)"ArchiveException not expected");
        }
    }

    @Test
    public void testMessageWhenInputStreamIsNull() {
        try {
            new ArchiveStreamFactory().createArchiveInputStream("zip", null);
            Assert.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)INPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            Assert.fail((String)"ArchiveException not expected");
        }
    }

    @Test
    public void testMessageWhenArchiverNameIsNull_2() {
        try {
            new ArchiveStreamFactory().createArchiveOutputStream(null, (OutputStream)System.out);
            Assert.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            Assert.fail((String)"ArchiveException not expected");
        }
    }

    @Test
    public void testMessageWhenOutputStreamIsNull() {
        try {
            new ArchiveStreamFactory().createArchiveOutputStream("zip", null);
            Assert.fail((String)"Should raise an IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)OUTPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
        }
        catch (ArchiveException e) {
            Assert.fail((String)"ArchiveException not expected");
        }
    }
}

