/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.junit.Assert;
import org.junit.Test;

public class SevenZTestCase
extends AbstractTestCase {
    @Test
    public void testSevenZArchiveCreationUsingCopy() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.COPY);
    }

    @Test
    public void testSevenZArchiveCreationUsingLZMA() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.LZMA);
    }

    @Test
    public void testSevenZArchiveCreationUsingLZMA2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.LZMA2);
    }

    @Test
    public void testSevenZArchiveCreationUsingBZIP2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.BZIP2);
    }

    @Test
    public void testSevenZArchiveCreationUsingDeflate() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.DEFLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSevenZArchiveCreation(SevenZMethod method) throws Exception {
        File output = new File(this.dir, "bla.7z");
        File file1 = SevenZTestCase.getFile("test1.xml");
        File file2 = SevenZTestCase.getFile("test2.xml");
        outArchive.setContentCompression(method);
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            SevenZArchiveEntry entry = outArchive.createArchiveEntry(file1, file1.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(file1, outArchive);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(file2, file2.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(file2, outArchive);
            outArchive.closeArchiveEntry();
        }
        try (SevenZFile archive = new SevenZFile(output);){
            SevenZArchiveEntry entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)entry.getName(), (Object)file1.getName());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)entry.getName(), (Object)file2.getName());
            assert (archive.getNextEntry() == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, SevenZOutputFile dst) throws IOException {
        try (FileInputStream fis = null;){
            int bytesRead;
            fis = new FileInputStream(src);
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) >= 0) {
                dst.write(buffer, 0, bytesRead);
            }
        }
    }
}

