/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testReadLongNamesGNU() throws Exception {
        this.checkLongNameEntry("longfile_gnu.ar");
    }

    @Test
    public void testReadLongNamesBSD() throws Exception {
        this.checkLongNameEntry("longfile_bsd.ar");
    }

    private void checkLongNameEntry(String archive) throws Exception {
        try (FileInputStream fis = new FileInputStream(ArArchiveInputStreamTest.getFile(archive));
             ArArchiveInputStream s = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));){
            ArchiveEntry e = s.getNextEntry();
            Assert.assertEquals((Object)"this_is_a_long_file_name.txt", (Object)e.getName());
            Assert.assertEquals((long)14L, (long)e.getSize());
            byte[] hello = new byte[14];
            s.read(hello);
            Assert.assertEquals((Object)"Hello, world!\n", (Object)ArchiveUtils.toAsciiString((byte[])hello));
            e = s.getNextEntry();
            Assert.assertEquals((Object)"this_is_a_long_file_name_as_well.txt", (Object)e.getName());
            Assert.assertEquals((long)4L, (long)e.getSize());
            byte[] bye = new byte[4];
            s.read(bye);
            Assert.assertEquals((Object)"Bye\n", (Object)ArchiveUtils.toAsciiString((byte[])bye));
            Assert.assertNull((Object)s.getNextEntry());
        }
    }
}

