/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.Assert;
import org.junit.Test;

public class SparseFilesTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOldGNU() throws Throwable {
        File file = AbstractTestCase.getFile("oldgnu_sparse.tar");
        try (TarArchiveInputStream tin = null;){
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assert.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assert.assertTrue((boolean)ae.isOldGNUSparse());
            Assert.assertTrue((boolean)ae.isGNUSparse());
            Assert.assertFalse((boolean)ae.isPaxGNUSparse());
            Assert.assertFalse((boolean)tin.canReadEntryData((ArchiveEntry)ae));
        }
    }

    @Test
    public void testPaxGNU() throws Throwable {
        File file = AbstractTestCase.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = null;){
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));
            this.assertPaxGNUEntry(tin, "0.0");
            this.assertPaxGNUEntry(tin, "0.1");
            this.assertPaxGNUEntry(tin, "1.0");
        }
    }

    private void assertPaxGNUEntry(TarArchiveInputStream tin, String suffix) throws Throwable {
        TarArchiveEntry ae = tin.getNextTarEntry();
        Assert.assertEquals((Object)("sparsefile-" + suffix), (Object)ae.getName());
        Assert.assertTrue((boolean)ae.isGNUSparse());
        Assert.assertTrue((boolean)ae.isPaxGNUSparse());
        Assert.assertFalse((boolean)ae.isOldGNUSparse());
        Assert.assertFalse((boolean)tin.canReadEntryData((ArchiveEntry)ae));
    }
}

