/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarConstants;
import org.junit.Assert;
import org.junit.Test;

public class TarArchiveEntryTest
implements TarConstants {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String ROOT = OS.startsWith("windows") || OS.startsWith("netware") ? "C:\\" : "/";

    @Test
    public void testFileSystemRoot() {
        TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
        Assert.assertEquals((Object)"/", (Object)t.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTarFileWithFSRoot() throws IOException {
        File f = File.createTempFile("taetest", ".tar");
        f.deleteOnExit();
        TarArchiveOutputStream tout = null;
        TarArchiveInputStream tin = null;
        try {
            tout = new TarArchiveOutputStream((OutputStream)new FileOutputStream(f));
            TarArchiveEntry t = new TarArchiveEntry(new File(ROOT));
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.closeArchiveEntry();
            t = new TarArchiveEntry(new File(new File(ROOT), "foo.txt"));
            t.setSize(6L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{104, 101, 108, 108, 111, 32});
            tout.closeArchiveEntry();
            t = new TarArchiveEntry(new File(new File(ROOT), "bar.txt").getAbsolutePath());
            t.setSize(5L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{119, 111, 114, 108, 100});
            tout.closeArchiveEntry();
            t = new TarArchiveEntry("dummy");
            t.setName(new File(new File(ROOT), "baz.txt").getAbsolutePath());
            t.setSize(1L);
            tout.putArchiveEntry((ArchiveEntry)t);
            tout.write(new byte[]{33});
            tout.closeArchiveEntry();
            tout.close();
            tout = null;
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(f));
            t = tin.getNextTarEntry();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"/", (Object)t.getName());
            Assert.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"foo.txt", (Object)t.getName());
            Assert.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"bar.txt", (Object)t.getName());
            Assert.assertTrue((boolean)t.isCheckSumOK());
            t = tin.getNextTarEntry();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"baz.txt", (Object)t.getName());
            Assert.assertTrue((boolean)t.isCheckSumOK());
        }
        finally {
            if (tin != null) {
                tin.close();
            }
            if (tout != null) {
                tout.close();
            }
            AbstractTestCase.tryHardToDelete(f);
        }
    }

    @Test
    public void testMaxFileSize() {
        TarArchiveEntry t = new TarArchiveEntry("");
        t.setSize(0L);
        t.setSize(1L);
        try {
            t.setSize(-1L);
            Assert.fail((String)"Should have generated IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        t.setSize(0x1FFFFFFFFL);
        t.setSize(0x200000000L);
    }

    @Test
    public void testExtraPaxHeaders() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        TarArchiveEntry entry = new TarArchiveEntry("./weasels");
        entry.addPaxHeader("APACHE.mustelida", "true");
        entry.addPaxHeader("SCHILY.xattr.user.org.apache.weasels", "maximum weasels");
        entry.addPaxHeader("size", "1");
        Assert.assertEquals((String)"extra header count", (long)2L, (long)entry.getExtraPaxHeaders().size());
        Assert.assertEquals((String)"APACHE.mustelida", (Object)"true", (Object)entry.getExtraPaxHeader("APACHE.mustelida"));
        Assert.assertEquals((String)"SCHILY.xattr.user.org.apache.weasels", (Object)"maximum weasels", (Object)entry.getExtraPaxHeader("SCHILY.xattr.user.org.apache.weasels"));
        Assert.assertEquals((String)"size", (long)entry.getSize(), (long)1L);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write(87);
        tos.closeArchiveEntry();
        tos.close();
        Assert.assertNotEquals((String)"should have extra headers before clear", (long)0L, (long)entry.getExtraPaxHeaders().size());
        entry.clearExtraPaxHeaders();
        Assert.assertEquals((String)"extra headers should be empty after clear", (long)0L, (long)entry.getExtraPaxHeaders().size());
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        entry = tis.getNextTarEntry();
        Assert.assertNotNull((String)"couldn't get entry", (Object)entry);
        Assert.assertEquals((String)"extra header count", (long)2L, (long)entry.getExtraPaxHeaders().size());
        Assert.assertEquals((String)"APACHE.mustelida", (Object)"true", (Object)entry.getExtraPaxHeader("APACHE.mustelida"));
        Assert.assertEquals((String)"user.org.apache.weasels", (Object)"maximum weasels", (Object)entry.getExtraPaxHeader("SCHILY.xattr.user.org.apache.weasels"));
        Assert.assertEquals((long)87L, (long)tis.read());
        Assert.assertTrue((String)"should be at end of entry", (tis.read() < 0 ? 1 : 0) != 0);
        Assert.assertNull((String)"should be at end of file", (Object)tis.getNextTarEntry());
        tis.close();
    }

    @Test
    public void testLinkFlagConstructor() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76);
        this.assertGnuMagic(t);
        Assert.assertEquals((Object)"foo", (Object)t.getName());
    }

    @Test
    public void testLinkFlagConstructorWithFileFlag() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 48);
        this.assertPosixMagic(t);
        Assert.assertEquals((Object)"foo", (Object)t.getName());
    }

    @Test
    public void testLinkFlagConstructorWithPreserve() {
        TarArchiveEntry t = new TarArchiveEntry("/foo", 76, true);
        this.assertGnuMagic(t);
        Assert.assertEquals((Object)"/foo", (Object)t.getName());
    }

    private void assertGnuMagic(TarArchiveEntry t) {
        Assert.assertEquals((Object)"ustar  \u0000", (Object)this.readMagic(t));
    }

    private void assertPosixMagic(TarArchiveEntry t) {
        Assert.assertEquals((Object)"ustar\u000000", (Object)this.readMagic(t));
    }

    private String readMagic(TarArchiveEntry t) {
        byte[] buf = new byte[512];
        t.writeEntryHeader(buf);
        return new String(buf, 257, 8);
    }
}

