/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.Assert;
import org.junit.Test;

public class EncryptedArchiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadPasswordEncryptedEntryViaZipFile() throws IOException {
        File file = AbstractTestCase.getFile("password-encrypted.zip");
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            ZipArchiveEntry zae = zf.getEntry("LICENSE.txt");
            Assert.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            Assert.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            Assert.assertFalse((boolean)zf.canReadEntryData(zae));
            try {
                zf.getInputStream(zae);
                Assert.fail((String)"expected an exception");
            }
            catch (UnsupportedZipFeatureException ex) {
                Assert.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadPasswordEncryptedEntryViaStream() throws IOException {
        File file = AbstractTestCase.getFile("password-encrypted.zip");
        try (ZipArchiveInputStream zin = null;){
            zin = new ZipArchiveInputStream((InputStream)new FileInputStream(file));
            ZipArchiveEntry zae = zin.getNextZipEntry();
            Assert.assertEquals((Object)"LICENSE.txt", (Object)zae.getName());
            Assert.assertTrue((boolean)zae.getGeneralPurposeBit().usesEncryption());
            Assert.assertFalse((boolean)zae.getGeneralPurposeBit().usesStrongEncryption());
            Assert.assertFalse((boolean)zin.canReadEntryData((ArchiveEntry)zae));
            try {
                byte[] buf = new byte[1024];
                zin.read(buf, 0, buf.length);
                Assert.fail((String)"expected an exception");
            }
            catch (UnsupportedZipFeatureException ex) {
                Assert.assertSame((Object)UnsupportedZipFeatureException.Feature.ENCRYPTION, (Object)ex.getFeature());
            }
        }
    }
}

