/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZipArchiveInputStreamTest {
    @Test
    public void winzipBackSlashWorkaround() throws Exception {
        try (ZipArchiveInputStream in = null;){
            in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("test-winzip.zip")));
            ZipArchiveEntry zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            Assert.assertEquals((Object)"\u00e4/", (Object)zae.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void properUseOfInflater() throws Exception {
        ZipFile zf = null;
        ZipArchiveInputStream in = null;
        try {
            ZipArchiveEntry innerEntry;
            zf = new ZipFile(AbstractTestCase.getFile("COMPRESS-189.zip"));
            ZipArchiveEntry zae = zf.getEntry("USD0558682-20080101.ZIP");
            in = new ZipArchiveInputStream((InputStream)new BufferedInputStream(zf.getInputStream(zae)));
            while ((innerEntry = in.getNextZipEntry()) != null) {
                if (!innerEntry.getName().endsWith("XML")) continue;
                Assert.assertTrue((0 < in.read() ? 1 : 0) != 0);
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void shouldConsumeArchiveCompletely() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.zip");
        ZipArchiveInputStream zip = new ZipArchiveInputStream(is);
        while (zip.getNextZipEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        zip.close();
    }

    @Test
    public void shouldReadNestedZip() throws IOException {
        try (ZipArchiveInputStream in = null;){
            in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("COMPRESS-219.zip")));
            this.extractZipInputStream(in);
        }
    }

    private void extractZipInputStream(ZipArchiveInputStream in) throws IOException {
        ZipArchiveEntry zae = in.getNextZipEntry();
        while (zae != null) {
            if (zae.getName().endsWith(".zip")) {
                this.extractZipInputStream(new ZipArchiveInputStream((InputStream)in));
            }
            zae = in.getNextZipEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnshrinkEntry() throws Exception {
        ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("SHRUNK.ZIP")));
        ZipArchiveEntry entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        try (FileInputStream original = new FileInputStream(AbstractTestCase.getFile("test1.xml"));){
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        entry = in.getNextZipEntry();
        Assert.assertEquals((String)"method", (long)ZipMethod.UNSHRINKING.getCode(), (long)entry.getMethod());
        Assert.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        original = new FileInputStream(AbstractTestCase.getFile("test2.xml"));
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            original.close();
        }
    }

    @Test
    public void testReadingOfFirstStoredEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("COMPRESS-264.zip")));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assert.assertEquals((long)5L, (long)ze.getSize());
            Assert.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Test
    public void testMessageWithCorruptFileName() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("COMPRESS-351.zip")));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            while (ze != null) {
                ze = in.getNextZipEntry();
            }
            Assert.fail((String)"expected EOFException");
        }
        catch (EOFException ex) {
            String m = ex.getMessage();
            Assert.assertTrue((boolean)m.startsWith("Truncated ZIP entry: ?2016"));
        }
    }

    @Test
    public void testUnzipBZip2CompressedEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new FileInputStream(AbstractTestCase.getFile("bzip2-zip.zip")));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assert.assertEquals((long)42L, (long)ze.getSize());
            byte[] expected = new byte[42];
            Arrays.fill(expected, (byte)97);
            Assert.assertArrayEquals((byte[])expected, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithBytesAfterData() throws Exception {
        int expectedNumEntries = 2;
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_bytes_after_data.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            int actualNumEntries = 0;
            ZipArchiveEntry zae = zip.getNextZipEntry();
            while (zae != null) {
                ++actualNumEntries;
                ZipArchiveInputStreamTest.readEntry(zip, zae);
                zae = zip.getNextZipEntry();
            }
            Assert.assertEquals((long)2L, (long)actualNumEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrowOnInvalidEntry() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/invalid-zip.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            zip.getNextZipEntry();
            Assert.fail((String)"IOException expected");
        }
    }

    @Test
    public void testOffsets() throws Exception {
        try (InputStream archiveStream = ZipArchiveInputStream.class.getResourceAsStream("/mixed.zip");
             ZipArchiveInputStream zipStream = new ZipArchiveInputStream(archiveStream);){
            ZipArchiveEntry inflatedEntry = zipStream.getNextZipEntry();
            Assert.assertEquals((Object)"inflated.txt", (Object)inflatedEntry.getName());
            Assert.assertEquals((long)0L, (long)inflatedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)70L, (long)inflatedEntry.getDataOffset());
            ZipArchiveEntry storedEntry = zipStream.getNextZipEntry();
            Assert.assertEquals((Object)"stored.txt", (Object)storedEntry.getName());
            Assert.assertEquals((long)22674L, (long)storedEntry.getLocalHeaderOffset());
            Assert.assertEquals((long)22742L, (long)storedEntry.getDataOffset());
            Assert.assertNull((Object)zipStream.getNextZipEntry());
        }
    }

    private static byte[] readEntry(ZipArchiveInputStream zip, ZipArchiveEntry zae) throws IOException {
        int len = (int)zae.getSize();
        byte[] buff = new byte[len];
        zip.read(buff, 0, len);
        return buff;
    }
}

