/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class GZipTestCase
extends AbstractTestCase {
    @Test
    public void testGzipCreation() throws Exception {
        File input = GZipTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.gz");
        try (FileOutputStream out = new FileOutputStream(output);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)out);){
            IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGzipUnarchive() throws Exception {
        File input = GZipTestCase.getFile("bla.tgz");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }

    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = GZipTestCase.getFile("multiple.gz");
        try (FileInputStream is = new FileInputStream(input);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)is);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = GZipTestCase.getFile("multiple.gz");
        try (FileInputStream is = new FileInputStream(input);
             GzipCompressorInputStream in = new GzipCompressorInputStream((InputStream)is, true);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)98L, (long)in.read());
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedInput() throws Exception {
        InputStream in = null;
        OutputStream out = null;
        CompressorInputStream cin = null;
        try {
            in = new FileInputStream(GZipTestCase.getFile("bla.tgz"));
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            byte[] data = ((ByteArrayOutputStream)out).toByteArray();
            in = new ByteArrayInputStream(data, 0, data.length - 1);
            cin = new CompressorStreamFactory().createCompressorInputStream("gz", in);
            out = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)cin, (OutputStream)out);
                Assert.fail((String)"Expected an exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (cin != null) {
                cin.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testInteroperabilityWithGzipCompressorInputStream() throws Exception {
        byte[] content;
        try (FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));){
            content = IOUtils.toByteArray((InputStream)fis);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setOperatingSystem(3);
        parameters.setFilename("test3.xml");
        parameters.setComment("Test file");
        parameters.setModificationTime(System.currentTimeMillis());
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        out.write(content);
        out.flush();
        out.close();
        GzipCompressorInputStream in = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        byte[] content2 = IOUtils.toByteArray((InputStream)in);
        Assert.assertArrayEquals((String)"uncompressed content", (byte[])content, (byte[])content2);
    }

    @Test
    public void testInteroperabilityWithGZIPInputStream() throws Exception {
        byte[] content;
        try (FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));){
            content = IOUtils.toByteArray((InputStream)fis);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setOperatingSystem(3);
        parameters.setFilename("test3.xml");
        parameters.setComment("Test file");
        parameters.setModificationTime(System.currentTimeMillis());
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        out.write(content);
        out.flush();
        out.close();
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bout.toByteArray()));
        byte[] content2 = IOUtils.toByteArray((InputStream)in);
        Assert.assertArrayEquals((String)"uncompressed content", (byte[])content, (byte[])content2);
    }

    @Test
    public void testInvalidCompressionLevel() {
        GzipParameters parameters = new GzipParameters();
        try {
            parameters.setCompressionLevel(10);
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            parameters.setCompressionLevel(-5);
            Assert.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testExtraFlags(int compressionLevel, int flag) throws Exception {
        byte[] content;
        try (FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));){
            content = IOUtils.toByteArray((InputStream)fis);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(compressionLevel);
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        IOUtils.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)out);
        out.flush();
        out.close();
        Assert.assertEquals((String)"extra flags (XFL)", (long)flag, (long)bout.toByteArray()[8]);
    }

    @Test
    public void testExtraFlagsFastestCompression() throws Exception {
        this.testExtraFlags(1, 4);
    }

    @Test
    public void testExtraFlagsBestCompression() throws Exception {
        this.testExtraFlags(9, 2);
    }

    @Test
    public void testExtraFlagsDefaultCompression() throws Exception {
        this.testExtraFlags(-1, 0);
    }

    @Test
    public void testOverWrite() throws Exception {
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)new ByteArrayOutputStream());
        out.close();
        try {
            out.write(0);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMetadataRoundTrip() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setModificationTime(123456000L);
        parameters.setOperatingSystem(13);
        parameters.setFilename("test3.xml");
        parameters.setComment("Umlaute m\u00c3\u00b6glich?");
        try (GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
             FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));){
            IOUtils.copy((InputStream)fis, (OutputStream)out);
        }
        GzipCompressorInputStream input = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        input.close();
        GzipParameters readParams = input.getMetaData();
        Assert.assertEquals((long)9L, (long)readParams.getCompressionLevel());
        Assert.assertEquals((long)123456000L, (long)readParams.getModificationTime());
        Assert.assertEquals((long)13L, (long)readParams.getOperatingSystem());
        Assert.assertEquals((Object)"test3.xml", (Object)readParams.getFilename());
        Assert.assertEquals((Object)"Umlaute m\u00c3\u00b6glich?", (Object)readParams.getComment());
    }
}

