/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class LZMATestCase
extends AbstractTestCase {
    @Test
    public void lzmaRoundtrip() throws Exception {
        byte[] uncompressed;
        byte[] orig;
        Throwable throwable;
        Object cos;
        File input = LZMATestCase.getFile("test1.xml");
        File compressed = new File(this.dir, "test1.xml.xz");
        try (FileOutputStream out = new FileOutputStream(compressed);){
            cos = new CompressorStreamFactory().createCompressorOutputStream("lzma", (OutputStream)out);
            throwable = null;
            try {
                IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cos != null) {
                    if (throwable != null) {
                        try {
                            cos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cos.close();
                    }
                }
            }
        }
        FileInputStream is = new FileInputStream(input);
        cos = null;
        try {
            orig = IOUtils.toByteArray((InputStream)is);
        }
        catch (Throwable throwable4) {
            cos = throwable4;
            throw throwable4;
        }
        finally {
            if (is != null) {
                if (cos != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)cos).addSuppressed(throwable5);
                    }
                } else {
                    ((InputStream)is).close();
                }
            }
        }
        throwable = null;
        try (FileInputStream is2 = new FileInputStream(compressed);
             LZMACompressorInputStream in = new LZMACompressorInputStream((InputStream)is2);){
            uncompressed = IOUtils.toByteArray((InputStream)in);
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        Assert.assertArrayEquals((byte[])orig, (byte[])uncompressed);
    }

    @Test
    public void testLZMAUnarchive() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            LZMACompressorInputStream in = new LZMACompressorInputStream((InputStream)is);
            this.copy((InputStream)in, output);
        }
    }

    @Test
    public void testLZMAUnarchiveWithAutodetection() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)is);
            this.copy((InputStream)in, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream in, File output) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(output);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            in.close();
        }
    }
}

