/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class Pack200TestCase
extends AbstractTestCase {
    @Test
    public void testJarUnarchiveAllInMemory() throws Exception {
        this.jarUnarchiveAll(false, Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarUnarchiveAllFileArgInMemory() throws Exception {
        this.jarUnarchiveAll(true, Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarUnarchiveAllTempFile() throws Exception {
        this.jarUnarchiveAll(false, Pack200Strategy.TEMP_FILE);
    }

    @Test
    public void testJarUnarchiveAllFileTempFile() throws Exception {
        this.jarUnarchiveAll(true, Pack200Strategy.TEMP_FILE);
    }

    private void jarUnarchiveAll(boolean useFile, Pack200Strategy mode) throws Exception {
        File input = Pack200TestCase.getFile("bla.pack");
        try (Pack200CompressorInputStream is = useFile ? new Pack200CompressorInputStream(input, mode) : new Pack200CompressorInputStream((InputStream)new FileInputStream(input), mode);){
            ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.dir, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(archiveEntry);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
                entry = in.getNextEntry();
            }
            in.close();
        }
    }

    @Test
    public void testJarArchiveCreationInMemory() throws Exception {
        this.jarArchiveCreation(Pack200Strategy.IN_MEMORY);
    }

    @Test
    public void testJarArchiveCreationTempFile() throws Exception {
        this.jarArchiveCreation(Pack200Strategy.TEMP_FILE);
    }

    private void jarArchiveCreation(Pack200Strategy mode) throws Exception {
        File output = new File(this.dir, "bla.pack");
        File file1 = Pack200TestCase.getFile("test1.xml");
        File file2 = Pack200TestCase.getFile("test2.xml");
        try (Pack200CompressorOutputStream out = new Pack200CompressorOutputStream((OutputStream)new FileOutputStream(output), mode);){
            ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)out);
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            IOUtils.copy((InputStream)new FileInputStream(file1), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)os);
            os.closeArchiveEntry();
            os.close();
        }
        var6_6 = null;
        try (Pack200CompressorInputStream is = new Pack200CompressorInputStream(output);){
            ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
            ArrayList<String> files = new ArrayList<String>();
            files.add("testdata/test1.xml");
            files.add("testdata/test2.xml");
            this.checkArchiveContent(in, files);
            in.close();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testGoodSignature() throws Exception {
        try (FileInputStream is = new FileInputStream(Pack200TestCase.getFile("bla.pack"));){
            byte[] sig = new byte[4];
            ((InputStream)is).read(sig);
            Assert.assertTrue((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)4));
        }
    }

    @Test
    public void testBadSignature() throws Exception {
        try (FileInputStream is = new FileInputStream(Pack200TestCase.getFile("bla.jar"));){
            byte[] sig = new byte[4];
            ((InputStream)is).read(sig);
            Assert.assertFalse((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)4));
        }
    }

    @Test
    public void testShortSignature() throws Exception {
        try (FileInputStream is = new FileInputStream(Pack200TestCase.getFile("bla.pack"));){
            byte[] sig = new byte[2];
            ((InputStream)is).read(sig);
            Assert.assertFalse((boolean)Pack200CompressorInputStream.matches((byte[])sig, (int)2));
        }
    }

    @Test
    public void testInputStreamMethods() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        try (Pack200CompressorInputStream is = new Pack200CompressorInputStream((InputStream)new FileInputStream(Pack200TestCase.getFile("bla.jar")), m);){
            Assert.assertTrue((boolean)is.markSupported());
            is.mark(5);
            Assert.assertEquals((long)80L, (long)is.read());
            byte[] rest = new byte[3];
            Assert.assertEquals((long)3L, (long)is.read(rest));
            Assert.assertEquals((long)75L, (long)rest[0]);
            Assert.assertEquals((long)3L, (long)rest[1]);
            Assert.assertEquals((long)4L, (long)rest[2]);
            Assert.assertEquals((long)1L, (long)is.skip(1L));
            is.reset();
            Assert.assertEquals((long)80L, (long)is.read());
            Assert.assertTrue((is.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOutputStreamMethods() throws Exception {
        File output = new File(this.dir, "bla.pack");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        try (FileOutputStream out = new FileOutputStream(output);){
            Pack200CompressorOutputStream os = new Pack200CompressorOutputStream((OutputStream)out, m);
            os.write(1);
            os.write(new byte[]{2, 3});
            os.close();
        }
    }
}

