/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class BrotliCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void testBrotliDecode() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        File expected = BrotliCompressorInputStreamTest.getFile("brotli.testdata.uncompressed");
        try (FileInputStream inputStream = new FileInputStream(input);
             FileInputStream expectedStream = new FileInputStream(expected);
             BrotliCompressorInputStream brotliInputStream = new BrotliCompressorInputStream((InputStream)inputStream);){
            byte[] b = new byte[20];
            IOUtils.readFully((InputStream)expectedStream, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = brotliInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testCachingIsEnabledByDefaultAndBrotliIsPresent() {
        Assert.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        Assert.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            Assert.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }

    @Test
    public void availableShouldReturnZero() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (FileInputStream is = new FileInputStream(input);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream((InputStream)is);
            Assert.assertTrue((in.available() == 0 ? 1 : 0) != 0);
            in.close();
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (FileInputStream is = new FileInputStream(input);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (FileInputStream is = new FileInputStream(input);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)88L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void singleByteReadReturnsMinusOneAtEof() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (FileInputStream is = new FileInputStream(input);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrotliUnarchive() throws Exception {
        File input = BrotliCompressorInputStreamTest.getFile("bla.tar.br");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("br", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }
}

