/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class BZip2CompressorInputStreamTest {
    @Test(expected=IOException.class)
    public void shouldThrowAnIOExceptionWhenAppliedToAZipFile() throws Exception {
        try (FileInputStream in = new FileInputStream(AbstractTestCase.getFile("bla.zip"));){
            BZip2CompressorInputStream bis = new BZip2CompressorInputStream((InputStream)in);
            bis.close();
        }
    }

    @Test
    public void readOfLength0ShouldReturn0() throws Exception {
        byte[] rawData = new byte[0x100000];
        for (int i = 0; i < rawData.length; ++i) {
            rawData[i] = (byte)Math.floor(Math.random() * 256.0);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BZip2CompressorOutputStream bzipOut = new BZip2CompressorOutputStream((OutputStream)baos);
        bzipOut.write(rawData);
        bzipOut.flush();
        bzipOut.close();
        baos.flush();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BZip2CompressorInputStream bzipIn = new BZip2CompressorInputStream((InputStream)bais);
        byte[] buffer = new byte[1024];
        Assert.assertEquals((long)1024L, (long)bzipIn.read(buffer, 0, 1024));
        Assert.assertEquals((long)0L, (long)bzipIn.read(buffer, 1024, 0));
        Assert.assertEquals((long)1024L, (long)bzipIn.read(buffer, 0, 1024));
        bzipIn.close();
    }
}

