/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import org.apache.commons.compress.compressors.xz.XZUtils;
import org.junit.Assert;
import org.junit.Test;

public class XZUtilsTestCase {
    @Test
    public void testIsCompressedFilename() {
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)""));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)".xz"));
        Assert.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.txz"));
        Assert.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.xz"));
        Assert.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x-xz"));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xxgz"));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xzz"));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xaz"));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz "));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz\n"));
        Assert.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assert.assertEquals((Object)"", (Object)XZUtils.getUncompressedFilename((String)""));
        Assert.assertEquals((Object)".xz", (Object)XZUtils.getUncompressedFilename((String)".xz"));
        Assert.assertEquals((Object)"x.tar", (Object)XZUtils.getUncompressedFilename((String)"x.txz"));
        Assert.assertEquals((Object)"x", (Object)XZUtils.getUncompressedFilename((String)"x.xz"));
        Assert.assertEquals((Object)"x", (Object)XZUtils.getUncompressedFilename((String)"x-xz"));
        Assert.assertEquals((Object)"x.txz ", (Object)XZUtils.getUncompressedFilename((String)"x.txz "));
        Assert.assertEquals((Object)"x.txz\n", (Object)XZUtils.getUncompressedFilename((String)"x.txz\n"));
        Assert.assertEquals((Object)"x.txz.y", (Object)XZUtils.getUncompressedFilename((String)"x.txz.y"));
    }

    @Test
    public void testGetCompressedFilename() {
        Assert.assertEquals((Object)".xz", (Object)XZUtils.getCompressedFilename((String)""));
        Assert.assertEquals((Object)"x.xz", (Object)XZUtils.getCompressedFilename((String)"x"));
        Assert.assertEquals((Object)"x.txz", (Object)XZUtils.getCompressedFilename((String)"x.tar"));
        Assert.assertEquals((Object)"x.wmf .xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf "));
        Assert.assertEquals((Object)"x.wmf\n.xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf\n"));
        Assert.assertEquals((Object)"x.wmf.y.xz", (Object)XZUtils.getCompressedFilename((String)"x.wmf.y"));
    }

    @Test
    public void testMatches() {
        byte[] data = new byte[]{-3, 55, 122, 88, 90, 0};
        Assert.assertFalse((boolean)XZUtils.matches((byte[])data, (int)5));
        Assert.assertTrue((boolean)XZUtils.matches((byte[])data, (int)6));
        Assert.assertTrue((boolean)XZUtils.matches((byte[])data, (int)7));
        data[5] = 48;
        Assert.assertFalse((boolean)XZUtils.matches((byte[])data, (int)6));
    }

    @Test
    public void testCachingIsEnabledByDefaultAndXZIsPresent() {
        Assert.assertEquals((Object)XZUtils.CachedAvailability.CACHED_AVAILABLE, (Object)XZUtils.getCachedXZAvailability());
        Assert.assertTrue((boolean)XZUtils.isXZCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            XZUtils.setCacheXZAvailablity((boolean)false);
            Assert.assertEquals((Object)XZUtils.CachedAvailability.DONT_CACHE, (Object)XZUtils.getCachedXZAvailability());
            Assert.assertTrue((boolean)XZUtils.isXZCompressionAvailable());
        }
        finally {
            XZUtils.setCacheXZAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            XZUtils.setCacheXZAvailablity((boolean)false);
            Assert.assertEquals((Object)XZUtils.CachedAvailability.DONT_CACHE, (Object)XZUtils.getCachedXZAvailability());
            XZUtils.setCacheXZAvailablity((boolean)true);
            Assert.assertEquals((Object)XZUtils.CachedAvailability.CACHED_AVAILABLE, (Object)XZUtils.getCachedXZAvailability());
        }
        finally {
            XZUtils.setCacheXZAvailablity((boolean)true);
        }
    }
}

