/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsTest {
    @Test
    public void skipUsingSkip() throws Exception {
        this.skip(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream toWrap) {
                return toWrap;
            }
        });
    }

    @Test
    public void skipUsingRead() throws Exception {
        this.skip(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream toWrap) {
                return new FilterInputStream(toWrap){

                    @Override
                    public long skip(long s) {
                        return 0L;
                    }
                };
            }
        });
    }

    @Test
    public void skipUsingSkipAndRead() throws Exception {
        this.skip(new StreamWrapper(){

            @Override
            public InputStream wrap(final InputStream toWrap) {
                return new FilterInputStream(toWrap){
                    boolean skipped;

                    @Override
                    public long skip(long s) throws IOException {
                        if (!this.skipped) {
                            toWrap.skip(5L);
                            this.skipped = true;
                            return 5L;
                        }
                        return 0L;
                    }
                };
            }
        });
    }

    @Test
    public void readFullyOnChannelReadsFully() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(20);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        IOUtilsTest.readFully(source, b);
        Assert.assertArrayEquals((byte[])source, (byte[])b.array());
    }

    @Test(expected=EOFException.class)
    public void readFullyOnChannelThrowsEof() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(21);
        byte[] source = new byte[20];
        for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
            source[i] = i;
        }
        IOUtilsTest.readFully(source, b);
    }

    private static void readFully(final byte[] source, ByteBuffer b) throws IOException {
        IOUtils.readFully((ReadableByteChannel)new ReadableByteChannel(){
            private int idx;

            @Override
            public int read(ByteBuffer buf) {
                if (this.idx >= source.length) {
                    return -1;
                }
                buf.put(source[this.idx++]);
                return 1;
            }

            @Override
            public void close() {
            }

            @Override
            public boolean isOpen() {
                return true;
            }
        }, (ByteBuffer)b);
    }

    private void skip(StreamWrapper wrapper) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        InputStream sut = wrapper.wrap(in);
        Assert.assertEquals((long)10L, (long)IOUtils.skip((InputStream)sut, (long)10L));
        Assert.assertEquals((long)11L, (long)sut.read());
    }

    private static interface StreamWrapper {
        public InputStream wrap(InputStream var1);
    }
}

