/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;

public class CollectionSampler<T>
implements SharedStateObjectSampler<T> {
    private final List<T> items;
    private final UniformRandomProvider rng;

    public CollectionSampler(UniformRandomProvider rng, Collection<T> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        this.rng = rng;
        this.items = new ArrayList<T>(collection);
    }

    private CollectionSampler(UniformRandomProvider rng, CollectionSampler<T> source) {
        this.rng = rng;
        this.items = source.items;
    }

    @Override
    public T sample() {
        return this.items.get(this.rng.nextInt(this.items.size()));
    }

    @Override
    public CollectionSampler<T> withUniformRandomProvider(UniformRandomProvider rng) {
        return new CollectionSampler<T>(rng, this);
    }
}

