/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.mime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.mime.MimeAttributesMap;
import org.apache.commons.vfs2.provider.mime.MimeFileContentInfoFactory;
import org.apache.commons.vfs2.provider.mime.MimeFileSystem;
import org.apache.commons.vfs2.util.FileObjectUtils;

public class MimeFileObject
extends AbstractFileObject<MimeFileSystem>
implements FileObject {
    private Part part;
    private Map<String, Object> attributeMap;

    protected MimeFileObject(AbstractFileName name, Part part, MimeFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.setPart(part);
    }

    protected void doAttach() throws Exception {
        if (this.part == null) {
            if (!this.getName().equals(this.getFileSystem().getRootName())) {
                MimeFileObject foParent = (MimeFileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getParent());
                this.setPart(foParent.findPart(this.getName().getBaseName()));
                return;
            }
            this.setPart(((MimeFileSystem)this.getFileSystem()).createCommunicationLink());
        }
    }

    private Part findPart(String partName) throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            return null;
        }
        if (this.isMultipart()) {
            Multipart multipart = (Multipart)this.part.getContent();
            if (partName.startsWith("_body_part_")) {
                int partNumber = Integer.parseInt(partName.substring("_body_part_".length()), 10);
                if (partNumber < 0 || partNumber + 1 > multipart.getCount()) {
                    return null;
                }
                return multipart.getBodyPart(partNumber);
            }
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart childPart = multipart.getBodyPart(i);
                if (!partName.equals(childPart.getFileName())) continue;
                return childPart;
            }
        }
        return null;
    }

    protected void doDetach() throws Exception {
    }

    protected FileType doGetType() throws Exception {
        if (this.part == null) {
            return FileType.IMAGINARY;
        }
        if (this.isMultipart()) {
            return FileType.FILE_OR_FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        Object container;
        if (this.part == null) {
            return null;
        }
        ArrayList<MimeFileObject> vfs = new ArrayList<MimeFileObject>();
        if (this.isMultipart() && (container = this.part.getContent()) instanceof Multipart) {
            Multipart multipart = (Multipart)container;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String filename = UriParser.encode((String)part.getFileName());
                if (filename == null) {
                    filename = "_body_part_" + i;
                }
                MimeFileObject fo = (MimeFileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), filename, NameScope.CHILD)));
                fo.setPart((Part)part);
                vfs.add(fo);
            }
        }
        return vfs.toArray(new MimeFileObject[vfs.size()]);
    }

    private void setPart(Part part) {
        this.part = part;
        this.attributeMap = null;
    }

    protected long doGetContentSize() throws Exception {
        return this.part.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        Message mm = this.getMessage();
        if (mm == null) {
            return -1L;
        }
        if (mm.getSentDate() != null) {
            return mm.getSentDate().getTime();
        }
        if (mm.getReceivedDate() != null) {
            mm.getReceivedDate();
        }
        return 0L;
    }

    private Message getMessage() throws FileSystemException {
        if (this.part instanceof Message) {
            return (Message)this.part;
        }
        return ((MimeFileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getParent())).getMessage();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (this.isMultipart()) {
            String preamble = ((MimeMultipart)this.part.getContent()).getPreamble();
            if (preamble == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(preamble.getBytes("UTF-8"));
        }
        return this.part.getInputStream();
    }

    boolean isMultipart() throws MessagingException {
        return this.part.getContentType() != null && this.part.getContentType().startsWith("multipart/");
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new MimeFileContentInfoFactory();
    }

    protected Part getPart() {
        return this.part;
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        if (this.attributeMap == null) {
            this.attributeMap = this.part != null ? new MimeAttributesMap(this.part) : Collections.emptyMap();
        }
        return this.attributeMap;
    }

    protected Enumeration<Header> getAllHeaders() throws MessagingException {
        return this.part.getAllHeaders();
    }
}

