/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.mime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractLayeredFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.mime.MimeFileSystem;

public class MimeFileProvider
extends AbstractLayeredFileProvider
implements FileProvider {
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.ATTRIBUTES));

    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new MimeFileSystem((FileName)name, file, fileSystemOptions);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

