/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.mime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.mime.MimeFileObject;
import org.apache.commons.vfs2.provider.mime.MimeFileProvider;
import org.apache.commons.vfs2.util.SharedRandomContentInputStream;

public class MimeFileSystem
extends AbstractFileSystem {
    static final String NULL_BP_NAME = "_body_part_";
    static final String CONTENT_NAME = "_content";
    static final String PREAMBLE_CHARSET = "UTF-8";
    private final Log log = LogFactory.getLog(MimeFileSystem.class);
    private InputStream mimeStream = null;

    protected MimeFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        super(rootName, parentLayer, fileSystemOptions);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new MimeFileObject(name, null, this);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(MimeFileProvider.capabilities);
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.mimeStream == null) {
                return;
            }
            this.closeMimeStream();
            this.mimeStream = null;
        }
        catch (IOException e) {
            this.log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void closeMimeStream() throws IOException {
        if (this.mimeStream instanceof SharedRandomContentInputStream) {
            ((SharedRandomContentInputStream)this.mimeStream).closeAll();
        } else {
            this.mimeStream.close();
        }
    }

    public Part createCommunicationLink() throws IOException, MessagingException {
        FileObject parentLayer;
        if (this.mimeStream != null) {
            this.closeMimeStream();
        }
        if (!(parentLayer = this.getParentLayer()).exists()) {
            return null;
        }
        this.mimeStream = parentLayer.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ) ? new SharedRandomContentInputStream(parentLayer) : this.getParentLayer().getContent().getInputStream();
        return new MimeMessage(null, this.mimeStream);
    }
}

