/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.smb;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeHasNoContentException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.smb.SmbFileName;
import org.apache.commons.vfs2.provider.smb.SmbFileProvider;
import org.apache.commons.vfs2.provider.smb.SmbFileRandomAccessContent;
import org.apache.commons.vfs2.provider.smb.SmbFileSystem;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SmbFileObject
extends AbstractFileObject<SmbFileSystem> {
    private SmbFile file;

    protected SmbFileObject(AbstractFileName name, SmbFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.getName());
        }
    }

    protected void doDetach() throws Exception {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbFile createSmbFile(FileName fileName) throws MalformedURLException, SmbException, FileSystemException {
        SmbFile smbFile;
        SmbFileName smbFileName = (SmbFileName)fileName;
        String path = smbFileName.getUriWithoutAuth();
        UserAuthenticationData authData = null;
        try {
            SmbFile file;
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.getFileSystem().getFileSystemOptions(), (UserAuthenticationData.Type[])SmbFileProvider.AUTHENTICATOR_TYPES);
            NtlmPasswordAuthentication auth = null;
            if (authData != null) {
                auth = new NtlmPasswordAuthentication(UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.DOMAIN, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getDomain()))), UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getUserName()))), UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getPassword()))));
            }
            if ((file = new SmbFile(path, auth)).isDirectory() && !file.toString().endsWith("/")) {
                file = new SmbFile(path + "/", auth);
            }
            smbFile = file;
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        return smbFile;
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", (Object)this.getName());
    }

    protected String[] doListChildren() throws Exception {
        if (!this.file.isDirectory()) {
            return null;
        }
        return UriParser.encode((String[])this.file.list());
    }

    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.file.renameTo(this.createSmbFile(newfile.getName()));
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        try {
            return new SmbFileInputStream(this.file);
        }
        catch (SmbException e) {
            if (e.getNtStatus() == -1073741809) {
                throw new FileNotFoundException((Object)this.getName());
            }
            if (this.file.isDirectory()) {
                throw new FileTypeHasNoContentException((Object)this.getName());
            }
            throw e;
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new SmbFileOutputStream(this.file, bAppend);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SmbFileRandomAccessContent(this.file, mode);
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.file.setLastModified(modtime);
        return true;
    }
}

