/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.SharedInputStream;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class SharedRandomContentInputStream
extends BufferedInputStream
implements SharedInputStream {
    private final Set<SharedRandomContentInputStream> createdStreams;
    private final FileObject fo;
    private final long fileStart;
    private final long fileEnd;
    private long pos;
    private long resetCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedRandomContentInputStream(Set<SharedRandomContentInputStream> createdStreams, FileObject fo, long fileStart, long fileEnd, InputStream is) throws FileSystemException {
        super(is);
        if (!fo.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ)) {
            throw new FileSystemException("vfs.util/missing-capability.error", (Object)Capability.RANDOM_ACCESS_READ);
        }
        this.fo = fo;
        this.fileStart = fileStart;
        this.fileEnd = fileEnd;
        this.createdStreams = createdStreams;
        Set<SharedRandomContentInputStream> set = createdStreams;
        synchronized (set) {
            createdStreams.add(this);
        }
    }

    public SharedRandomContentInputStream(FileObject fo) throws FileSystemException {
        this(new HashSet<SharedRandomContentInputStream>(), fo, 0L, -1L, fo.getContent().getInputStream());
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.checkEnd()) {
            return -1;
        }
        int r = super.read();
        ++this.pos;
        ++this.resetCount;
        return r;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.checkEnd()) {
            return -1;
        }
        if (this.fileEnd > -1L && this.calcFilePosition(len) > this.fileEnd) {
            len = (int)(this.fileEnd - this.getFilePosition());
        }
        int nread = super.read(b, off, len);
        this.pos += (long)nread;
        this.resetCount += (long)nread;
        return nread;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.checkEnd()) {
            return -1L;
        }
        if (this.fileEnd > -1L && this.calcFilePosition(n) > this.fileEnd) {
            n = this.fileEnd - this.getFilePosition();
        }
        long nskip = super.skip(n);
        this.pos += nskip;
        this.resetCount += nskip;
        return nskip;
    }

    private boolean checkEnd() {
        return this.fileEnd > -1L && this.getFilePosition() >= this.fileEnd;
    }

    protected long getFilePosition() {
        return this.fileStart + this.pos;
    }

    protected long calcFilePosition(long nadd) {
        return this.getFilePosition() + nadd;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.resetCount = 0L;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.pos -= this.resetCount;
        this.resetCount = 0L;
    }

    public long getPosition() {
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        Set<SharedRandomContentInputStream> set = this.createdStreams;
        synchronized (set) {
            this.createdStreams.remove(this);
        }
    }

    public InputStream newStream(long start, long end) {
        try {
            long newFileStart = this.fileStart + start;
            long newFileEnd = end < 0L ? this.fileEnd : this.fileStart + end;
            RandomAccessContent rac = this.fo.getContent().getRandomAccessContent(RandomAccessMode.READ);
            rac.seek(newFileStart);
            return new SharedRandomContentInputStream(this.createdStreams, this.fo, newFileStart, newFileEnd, rac.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws IOException {
        Set<SharedRandomContentInputStream> set = this.createdStreams;
        synchronized (set) {
            SharedRandomContentInputStream[] streams = new SharedRandomContentInputStream[this.createdStreams.size()];
            this.createdStreams.toArray(streams);
            for (SharedRandomContentInputStream stream : streams) {
                stream.close();
            }
        }
    }
}

