/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.DefaultFileContent;

class FileContentThreadData {
    private ArrayList<InputStream> inputStreamList;
    private ArrayList<RandomAccessContent> randomAccessContentList;
    private DefaultFileContent.FileContentOutputStream outputStream;

    FileContentThreadData() {
    }

    void add(InputStream inputStream) {
        if (this.inputStreamList == null) {
            this.inputStreamList = new ArrayList();
        }
        this.inputStreamList.add(inputStream);
    }

    void add(RandomAccessContent randomAccessContent) {
        if (this.randomAccessContentList == null) {
            this.randomAccessContentList = new ArrayList();
        }
        this.randomAccessContentList.add(randomAccessContent);
    }

    void closeOutputStream() throws FileSystemException {
        this.outputStream.close();
        this.outputStream = null;
    }

    DefaultFileContent.FileContentOutputStream getOutputStream() {
        return this.outputStream;
    }

    boolean hasInputStream() {
        return this.inputStreamList != null && !this.inputStreamList.isEmpty();
    }

    boolean hasRandomAccessContent() {
        return this.randomAccessContentList != null && !this.randomAccessContentList.isEmpty();
    }

    boolean hasStreams() {
        return this.hasInputStream() || this.outputStream != null || this.hasRandomAccessContent();
    }

    InputStream removeInputStream(int pos) {
        return this.inputStreamList.remove(pos);
    }

    void remove(InputStream inputStream) {
        this.inputStreamList.remove(inputStream);
    }

    Object removeRandomAccessContent(int pos) {
        return this.randomAccessContentList.remove(pos);
    }

    void remove(RandomAccessContent randomAccessContent) {
        this.randomAccessContentList.remove(randomAccessContent);
    }

    void setOutputStream(DefaultFileContent.FileContentOutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

