/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http5.Http5FileNameParser;
import org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;

public class Http5FileProvider
extends AbstractOriginatingFileProvider {
    static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection<Capability> CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT));

    public Http5FileProvider() {
        this.setFileNameParser(Http5FileNameParser.getInstance());
    }

    private HttpClientConnectionManager createConnectionManager(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)builder.getSoTimeoutDuration(fileSystemOptions).toMillis())).build();
        String[] tlsVersions = builder.getTlsVersions(fileSystemOptions).split("\\s*,\\s*");
        TLS[] tlsArray = (TLS[])Arrays.stream(tlsVersions).map(TLS::valueOf).toArray(TLS[]::new);
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(this.createSSLContext(builder, fileSystemOptions)).setHostnameVerifier(this.createHostnameVerifier(builder, fileSystemOptions)).setTlsVersions(tlsArray).build();
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setMaxConnTotal(builder.getMaxTotalConnections(fileSystemOptions)).setMaxConnPerRoute(builder.getMaxConnectionsPerHost(fileSystemOptions)).setDefaultSocketConfig(socketConfig).build();
    }

    private CookieStore createDefaultCookieStore(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        Cookie[] cookies = builder.getCookies(fileSystemOptions);
        if (cookies != null) {
            Arrays.stream(cookies).forEach(arg_0 -> ((CookieStore)cookieStore).addCookie(arg_0));
        }
        return cookieStore;
    }

    private RequestConfig createDefaultRequestConfig(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        return RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)builder.getSoTimeoutDuration(fileSystemOptions).toMillis())).build();
    }

    private HostnameVerifier createHostnameVerifier(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (!builder.isHostnameVerificationEnabled(fileSystemOptions)) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return new DefaultHostnameVerifier();
    }

    protected HttpClient createHttpClient(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.createHttpClientBuilder(builder, rootName, fileSystemOptions).build();
    }

    protected HttpClientBuilder createHttpClientBuilder(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("User-Agent", (Object)builder.getUserAgent(fileSystemOptions)));
        DefaultConnectionReuseStrategy connectionReuseStrategy = builder.isKeepAlive(fileSystemOptions) ? DefaultConnectionReuseStrategy.INSTANCE : (request, response, context) -> false;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRoutePlanner(this.createHttpRoutePlanner(builder, fileSystemOptions)).setConnectionManager(this.createConnectionManager(builder, fileSystemOptions)).setConnectionReuseStrategy((ConnectionReuseStrategy)connectionReuseStrategy).setDefaultRequestConfig(this.createDefaultRequestConfig(builder, fileSystemOptions)).setDefaultHeaders(defaultHeaders).setDefaultCookieStore(this.createDefaultCookieStore(builder, fileSystemOptions));
        if (!builder.getFollowRedirect(fileSystemOptions)) {
            httpClientBuilder.disableRedirectHandling();
        }
        return httpClientBuilder;
    }

    protected HttpClientContext createHttpClientContext(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions, UserAuthenticationData authData) throws FileSystemException {
        UserAuthenticator proxyAuth;
        HttpHost proxyHost;
        HttpClientContext clientContext = HttpClientContext.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        String username = UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())));
        char[] password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
        if (!StringUtils.isEmpty((CharSequence)username)) {
            credsProvider.setCredentials(new AuthScope(rootName.getHostName(), rootName.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        if ((proxyHost = this.getProxyHttpHost(builder, fileSystemOptions)) != null && (proxyAuth = builder.getProxyAuthenticator(fileSystemOptions)) != null) {
            UserAuthenticationData proxyAuthData = UserAuthenticatorUtils.authenticate(proxyAuth, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD});
            if (proxyAuthData != null) {
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(proxyAuthData, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.getData(proxyAuthData, UserAuthenticationData.PASSWORD, null));
                credsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)proxyCreds);
            }
            if (builder.isPreemptiveAuth(fileSystemOptions)) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(proxyHost, (AuthScheme)basicAuth);
                clientContext.setAuthCache((AuthCache)authCache);
            }
        }
        return clientContext;
    }

    private HttpRoutePlanner createHttpRoutePlanner(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        HttpHost proxyHost = this.getProxyHttpHost(builder, fileSystemOptions);
        if (proxyHost != null) {
            return new DefaultProxyRoutePlanner(proxyHost);
        }
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    protected SSLContext createSSLContext(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.setKeyStoreType(builder.getKeyStoreType(fileSystemOptions));
            File keystoreFileObject = null;
            String keystoreFile = builder.getKeyStoreFile(fileSystemOptions);
            if (!StringUtils.isEmpty((CharSequence)keystoreFile)) {
                keystoreFileObject = new File(keystoreFile);
            }
            if (keystoreFileObject != null && keystoreFileObject.exists()) {
                String keystorePass = builder.getKeyStorePass(fileSystemOptions);
                char[] keystorePassChars = keystorePass != null ? keystorePass.toCharArray() : null;
                sslContextBuilder.loadTrustMaterial(keystoreFileObject, keystorePassChars, (TrustStrategy)TrustAllStrategy.INSTANCE);
            } else {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            }
            return sslContextBuilder.build();
        }
        catch (KeyStoreException e) {
            throw new FileSystemException("Keystore error. " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new FileSystemException("Cannot retrieve keys. " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FileSystemException("Algorithm error. " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new FileSystemException("Certificate error. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FileSystemException("Cannot open key file. " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient httpClient;
        HttpClientContext httpClientContext;
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        try {
            Http5FileSystemConfigBuilder builder = Http5FileSystemConfigBuilder.getInstance();
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClientContext = this.createHttpClientContext(builder, rootName, fileSystemOptions, authData);
            httpClient = this.createHttpClient(builder, rootName, fileSystemOptions);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return new Http5FileSystem(rootName, fileSystemOptions, httpClient, httpClientContext);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return Http5FileSystemConfigBuilder.getInstance();
    }

    private HttpHost getProxyHttpHost(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        String proxyScheme = builder.getProxyScheme(fileSystemOptions);
        String proxyHost = builder.getProxyHost(fileSystemOptions);
        int proxyPort = builder.getProxyPort(fileSystemOptions);
        if (!StringUtils.isEmpty((CharSequence)proxyHost) && proxyPort > 0) {
            return new HttpHost(proxyScheme, proxyHost, proxyPort);
        }
        return null;
    }
}

