/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.js.rhino;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Service;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.js.rhino.AbstractDOMProvider;
import org.apache.cxf.js.rhino.DOMMessageProvider;
import org.apache.cxf.js.rhino.DOMPayloadProvider;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ProviderFactory {
    public static final String ILLEGAL_SVCMD_MODE = ": unknown ServiceMode: ";
    public static final String ILLEGAL_SVCMD_TYPE = ": ServiceMode value must be of type string";
    public static final String NO_SUCH_FILE = ": file does not exist";
    public static final String NO_PROVIDER = ": file contains no WebServiceProviders";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private String epAddress;
    private boolean isBaseAddr;

    public ProviderFactory(String baseAddr) {
        this.epAddress = baseAddr;
        this.isBaseAddr = true;
    }

    public ProviderFactory() {
    }

    public void createAndPublish(File f, String epAddr, boolean isBase) throws Exception {
        this.publishImpl(f, epAddr, isBase);
    }

    public synchronized void createAndPublish(File f) throws Exception {
        this.publishImpl(f, this.epAddress, this.isBaseAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishImpl(File f, String epAddr, boolean isBase) throws Exception {
        if (!f.exists()) {
            throw new Exception(f.getPath() + NO_SUCH_FILE);
        }
        boolean isE4X = f.getName().endsWith(".jsx");
        BufferedReader bufrd = new BufferedReader(new FileReader(f));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = bufrd.readLine()) != null) {
            sb.append(line).append("\n");
        }
        String scriptStr = sb.toString();
        Context cx = ContextFactory.getGlobal().enterContext();
        boolean providerFound = false;
        try {
            ScriptableObject scriptScope = cx.initStandardObjects(null, true);
            Object[] ids = this.compileScript(cx, scriptStr, (Scriptable)scriptScope, f);
            if (ids.length > 0) {
                Service.Mode mode = Service.Mode.PAYLOAD;
                for (Object idObj : ids) {
                    Object obj;
                    String id;
                    if (!(idObj instanceof String) || !(id = (String)idObj).startsWith("WebServiceProvider") || !((obj = scriptScope.get(id, (Scriptable)scriptScope)) instanceof Scriptable)) continue;
                    Scriptable wspVar = (Scriptable)obj;
                    providerFound = true;
                    obj = wspVar.get("ServiceMode", wspVar);
                    if (obj != Scriptable.NOT_FOUND) {
                        if (!(obj instanceof String)) throw new Exception(f.getPath() + ILLEGAL_SVCMD_TYPE);
                        String value = (String)obj;
                        if ("PAYLOAD".equalsIgnoreCase(value)) {
                            mode = Service.Mode.PAYLOAD;
                        } else {
                            if (!"MESSAGE".equalsIgnoreCase(value)) throw new Exception(f.getPath() + ILLEGAL_SVCMD_MODE + value);
                            mode = Service.Mode.MESSAGE;
                        }
                    }
                    AbstractDOMProvider provider = this.createProvider(mode, (Scriptable)scriptScope, wspVar, epAddr, isBase, isE4X);
                    try {
                        provider.publish();
                    }
                    catch (AbstractDOMProvider.JSDOMProviderException ex) {
                        StringBuilder msg = new StringBuilder(f.getPath());
                        msg.append(": ").append(ex.getMessage());
                        throw new Exception(msg.toString());
                    }
                }
            }
        }
        finally {
            Context.exit();
        }
        if (providerFound) return;
        throw new Exception(f.getPath() + NO_PROVIDER);
    }

    protected AbstractDOMProvider createProvider(Service.Mode mode, Scriptable scope, Scriptable wsp, String epAddr, boolean isBase, boolean e4x) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            String modestr = mode == Service.Mode.PAYLOAD ? "payload" : "message";
            String type = e4x ? "E4X" : "JavaScript";
            String base = isBase ? "base " : "";
            StringBuilder msg = new StringBuilder("creating a ");
            msg.append(modestr).append(" ").append(type).append(" provider for ").append(base).append("address ").append(epAddr);
            LOG.log(Level.FINE, msg.toString());
        }
        AbstractDOMProvider provider = null;
        if (mode == Service.Mode.PAYLOAD) {
            provider = new DOMPayloadProvider(scope, wsp, epAddr, isBase, e4x);
        } else if (mode == Service.Mode.MESSAGE) {
            provider = new DOMMessageProvider(scope, wsp, epAddr, isBase, e4x);
        }
        return provider;
    }

    private Object[] compileScript(Context cx, String scriptStr, Scriptable scriptScope, File f) {
        int opt = cx.getOptimizationLevel();
        cx.setOptimizationLevel(-1);
        Script script = cx.compileString(scriptStr, f.getName(), 1, null);
        script.exec(cx, scriptScope);
        Object[] ids = scriptScope.getIds();
        cx.setOptimizationLevel(opt);
        script = cx.compileString(scriptStr, f.getName(), 1, null);
        script.exec(cx, scriptScope);
        return ids;
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new RhinoContextFactory());
    }

    static class RhinoContextFactory
    extends ContextFactory {
        RhinoContextFactory() {
        }

        public boolean hasFeature(Context cx, int feature) {
            if (feature == 7) {
                return true;
            }
            return super.hasFeature(cx, feature);
        }
    }
}

