/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.wsdl11;

import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CustomizedWSDLLocator
implements WSDLLocator {
    private String wsdlUrl;
    private ExtendedURIResolver resolver;
    private String baseUri;
    private String importedUri;
    private OASISCatalogManager catalogResolver;
    private Map<String, Element> elementMap;
    private String latestImportURI;
    private Map<String, String> resolvedMap = new HashMap<String, String>();
    private boolean resolveFromMap;

    public CustomizedWSDLLocator(String wsdlUrl, Map<String, Element> map) {
        this.baseUri = this.wsdlUrl = wsdlUrl;
        this.resolver = new ExtendedURIResolver();
        this.elementMap = map;
    }

    public void setCatalogResolver(OASISCatalogManager cr) {
        this.catalogResolver = cr;
    }

    private InputSource resolve(String target, String base) {
        try {
            String resolvedLocation = new OASISCatalogManagerHelper().resolve(this.catalogResolver, target, base);
            if (resolvedLocation == null) {
                return this.resolver.resolve(target, base);
            }
            this.resolvedMap.put(target, resolvedLocation);
            return this.resolver.resolve(resolvedLocation, base);
        }
        catch (Exception e) {
            throw new RuntimeException("Catalog resolve failed: ", e);
        }
    }

    public InputSource getBaseInputSource() {
        if (this.elementMap.get(this.baseUri) != null) {
            Element ele = this.elementMap.get(this.baseUri);
            String content = StaxUtils.toString(ele);
            InputSource ins = new InputSource(new StringReader(content));
            ins.setSystemId(this.baseUri);
            return ins;
        }
        InputSource result = this.resolve(this.baseUri, null);
        this.baseUri = this.resolver.getURI();
        return result;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public String getLatestImportURI() {
        if (this.resolveFromMap) {
            return this.latestImportURI;
        }
        return this.resolver.getLatestImportURI();
    }

    public InputSource getImportInputSource(String parent, String importLocation) {
        this.baseUri = parent;
        this.importedUri = importLocation;
        try {
            URI importURI = new URI(importLocation);
            if (!importURI.isAbsolute()) {
                URI parentURI = new URI(parent);
                importURI = parentURI.resolve(importURI);
            }
            if (this.elementMap.get(importURI.toString()) != null) {
                Element ele = this.elementMap.get(importURI.toString());
                String content = StaxUtils.toString(ele);
                InputSource ins = new InputSource(new StringReader(content));
                ins.setSystemId(importURI.toString());
                this.resolveFromMap = true;
                this.latestImportURI = importURI.toString();
                return ins;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to Resolve " + importLocation, e);
        }
        this.resolveFromMap = false;
        return this.resolve(this.importedUri, this.baseUri);
    }

    public void close() {
        this.resolver.close();
    }

    public Map<String, String> getResolvedMap() {
        return this.resolvedMap;
    }
}

