/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JNDIConfiguration;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.MessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;
import org.apache.cxf.transport.jms.util.UserCredentialsConnectionFactoryAdapter;

public final class JMSFactory {
    static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";

    private JMSFactory() {
    }

    static ConnectionFactory getConnectionFactoryFromJndi(JMSConfiguration jmsConfig) {
        JNDIConfiguration jndiConfig = jmsConfig.getJndiConfig();
        if (jndiConfig == null) {
            return null;
        }
        String connectionFactoryName = jndiConfig.getJndiConnectionFactoryName();
        if (connectionFactoryName == null) {
            return null;
        }
        String userName = jndiConfig.getConnectionUserName();
        String password = jndiConfig.getConnectionPassword();
        try {
            ConnectionFactory cf = jmsConfig.getJndiTemplate().lookup(connectionFactoryName, ConnectionFactory.class);
            if (userName != null) {
                UserCredentialsConnectionFactoryAdapter uccf = new UserCredentialsConnectionFactoryAdapter();
                uccf.setUsername(userName);
                uccf.setPassword(password);
                uccf.setTargetConnectionFactory(cf);
                cf = uccf;
            }
            return cf;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JMSSender createJmsSender(JMSConfiguration jmsConfig, JMSMessageHeadersType messageProperties) {
        JMSSender sender = new JMSSender();
        long timeToLive = messageProperties != null && messageProperties.isSetTimeToLive() ? messageProperties.getTimeToLive() : jmsConfig.getTimeToLive();
        sender.setTimeToLive(timeToLive);
        int priority = messageProperties != null && messageProperties.isSetJMSPriority() ? messageProperties.getJMSPriority() : jmsConfig.getPriority();
        sender.setPriority(priority);
        int deliveryMode = messageProperties != null && messageProperties.isSetJMSDeliveryMode() ? messageProperties.getJMSDeliveryMode() : jmsConfig.getDeliveryMode();
        sender.setDeliveryMode(deliveryMode);
        sender.setExplicitQosEnabled(jmsConfig.isExplicitQosEnabled());
        return sender;
    }

    private static String getMessageSelector(JMSConfiguration jmsConfig, String conduitId) {
        String staticSelectorPrefix = jmsConfig.getConduitSelectorPrefix();
        String conduitIdSt = jmsConfig.isUseConduitIdSelector() && conduitId != null ? conduitId : "";
        String correlationIdPrefix = staticSelectorPrefix + conduitIdSt;
        return correlationIdPrefix.isEmpty() ? null : "JMSCorrelationID LIKE '" + correlationIdPrefix + "%'";
    }

    public static JMSListenerContainer createTargetDestinationListener(EndpointInfo ei, JMSConfiguration jmsConfig, MessageListener listenerHandler) {
        MessageListenerContainer messageListenerContainer;
        Session session = null;
        try {
            Connection connection = JMSFactory.createConnection(jmsConfig);
            connection.start();
            session = connection.createSession(jmsConfig.isSessionTransacted(), 1);
            Destination destination = jmsConfig.getTargetDestination(session);
            MessageListenerContainer container = new MessageListenerContainer(connection, destination, listenerHandler);
            container.setMessageSelector(jmsConfig.getMessageSelector());
            container.start();
            messageListenerContainer = container;
        }
        catch (JMSException e) {
            try {
                throw JMSUtil.convertJmsException(e);
            }
            catch (Throwable throwable) {
                ResourceCloser.close(session);
                throw throwable;
            }
        }
        ResourceCloser.close(session);
        return messageListenerContainer;
    }

    public static JMSListenerContainer createSimpleJmsListener(JMSConfiguration jmsConfig, Connection connection, MessageListener listenerHandler, Destination destination, String conduitId) {
        MessageListenerContainer container = new MessageListenerContainer(connection, destination, listenerHandler);
        String messageSelector = JMSFactory.getMessageSelector(jmsConfig, conduitId);
        container.setMessageSelector(messageSelector);
        container.start();
        return container;
    }

    public static Connection createConnection(JMSConfiguration jmsConfig) throws JMSException {
        Connection connection = jmsConfig.getConnectionFactory().createConnection();
        if (jmsConfig.getDurableSubscriptionClientId() != null) {
            connection.setClientID(jmsConfig.getDurableSubscriptionClientId());
        }
        return connection;
    }
}

