/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.stax;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.util.stax.JDOMNamespaceContext;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;

public class JDOMStreamWriter
implements XMLStreamWriter {
    private Stack<Element> stack = new Stack();
    private Document document;
    private Element currentNode;
    private NamespaceContext context;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public JDOMStreamWriter() {
    }

    public JDOMStreamWriter(Element e) {
        this.newChild(e);
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeStartElement(String local) throws XMLStreamException {
        this.newChild(new Element(local));
    }

    private void newChild(Element element) {
        if (this.currentNode != null) {
            this.stack.push(this.currentNode);
            this.currentNode.addContent((Content)element);
        } else if (this.document != null) {
            this.document.setRootElement(element);
        }
        JDOMNamespaceContext ctx = new JDOMNamespaceContext();
        ctx.setElement(element);
        this.context = ctx;
        this.currentNode = element;
    }

    @Override
    public void writeStartElement(String namespace, String local) throws XMLStreamException {
        this.newChild(new Element(local, namespace));
    }

    @Override
    public void writeStartElement(String prefix, String local, String namespace) throws XMLStreamException {
        if (prefix == null || prefix.isEmpty()) {
            this.writeStartElement(namespace, local);
        } else {
            this.newChild(new Element(local, prefix, namespace));
        }
    }

    @Override
    public void writeEmptyElement(String namespace, String local) throws XMLStreamException {
        this.writeStartElement(namespace, local);
    }

    @Override
    public void writeEmptyElement(String prefix, String namespace, String local) throws XMLStreamException {
        this.writeStartElement(prefix, namespace, local);
    }

    @Override
    public void writeEmptyElement(String local) throws XMLStreamException {
        this.writeStartElement(local);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.currentNode = this.stack.pop();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value));
    }

    @Override
    public void writeAttribute(String prefix, String namespace, String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value, Namespace.getNamespace((String)prefix, (String)namespace)));
    }

    @Override
    public void writeAttribute(String namespace, String local, String value) throws XMLStreamException {
        this.currentNode.setAttribute(new Attribute(local, value, Namespace.getNamespace((String)namespace)));
    }

    @Override
    public void writeNamespace(String prefix, String namespace) throws XMLStreamException {
        Namespace decNS = this.currentNode.getNamespace(prefix);
        if (decNS == null || !decNS.getURI().equals(namespace)) {
            this.currentNode.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)namespace));
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) throws XMLStreamException {
        this.currentNode.addNamespaceDeclaration(Namespace.getNamespace((String)"", (String)namespace));
    }

    @Override
    public void writeComment(String value) throws XMLStreamException {
        this.currentNode.addContent((Content)new Comment(value));
    }

    @Override
    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.currentNode.addContent((Content)new CDATA(data));
    }

    @Override
    public void writeDTD(String arg0) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String ref) throws XMLStreamException {
        this.currentNode.addContent((Content)new EntityRef(ref));
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.document = new Document(new Element("root"));
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeStartDocument();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.currentNode.addContent(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.currentNode.addContent(new String(text, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return JDOMNamespaceContext.rawGetPrefix(this.currentNode, uri);
    }

    @Override
    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    @Override
    public void setDefaultNamespace(String arg0) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext ctx) throws XMLStreamException {
        this.context = ctx;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String prop) throws IllegalArgumentException {
        return this.properties.get(prop);
    }

    public Document getDocument() {
        return this.document;
    }
}

