/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;

public final class ClientProviderFactory
extends ProviderFactory {
    private static final String SHARED_CLIENT_FACTORY = "jaxrs.shared.client.factory";
    private List<ProviderInfo<ClientRequestFilter>> clientRequestFilters = new ArrayList<ProviderInfo<ClientRequestFilter>>(1);
    private List<ProviderInfo<ClientResponseFilter>> clientResponseFilters = new ArrayList<ProviderInfo<ClientResponseFilter>>(1);
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);

    private ClientProviderFactory(ProviderFactory baseFactory, Bus bus) {
        super(baseFactory, bus);
    }

    public static ClientProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ClientProviderFactory baseFactory = ClientProviderFactory.initBaseFactory(bus);
        ClientProviderFactory factory = new ClientProviderFactory(baseFactory, bus);
        factory.setBusProviders();
        return factory;
    }

    public static ClientProviderFactory getInstance(Bus bus) {
        return (ClientProviderFactory)((Object)bus.getProperty("org.apache.cxf.jaxrs.client.ClientProviderFactory"));
    }

    public static ClientProviderFactory getInstance(Message m) {
        Endpoint e = (Endpoint)m.getExchange().get(Endpoint.class);
        return (ClientProviderFactory)((Object)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory"));
    }

    public static ClientProviderFactory getInstance(Endpoint e) {
        return (ClientProviderFactory)((Object)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory"));
    }

    private static synchronized ClientProviderFactory initBaseFactory(Bus bus) {
        ClientProviderFactory factory = (ClientProviderFactory)((Object)bus.getProperty(SHARED_CLIENT_FACTORY));
        if (factory != null) {
            return factory;
        }
        factory = new ClientProviderFactory(null, bus);
        ProviderFactory.initBaseFactory((ProviderFactory)factory);
        bus.setProperty(SHARED_CLIENT_FACTORY, (Object)factory);
        return factory;
    }

    protected void setProviders(Object ... providers) {
        List theProviders = this.prepareProviders(providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo provider : theProviders) {
            Class providerCls;
            if (ClientProviderFactory.filterContractSupported((ProviderInfo)provider, (Class)(providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider())), ClientRequestFilter.class)) {
                this.addProviderToList(this.clientRequestFilters, provider);
            }
            if (ClientProviderFactory.filterContractSupported((ProviderInfo)provider, (Class)providerCls, ClientResponseFilter.class)) {
                this.addProviderToList(this.clientResponseFilters, provider);
            }
            if (!ResponseExceptionMapper.class.isAssignableFrom(providerCls)) continue;
            this.addProviderToList(this.responseExceptionMappers, provider);
        }
        Collections.sort(this.clientRequestFilters, new ProviderFactory.BindingPriorityComparator(ClientRequestFilter.class, true));
        Collections.sort(this.clientResponseFilters, new ProviderFactory.BindingPriorityComparator(ClientResponseFilter.class, false));
        this.injectContextProxies(new Collection[]{this.responseExceptionMappers, this.clientRequestFilters, this.clientResponseFilters});
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Message m, Class<?> paramType) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ResponseExceptionMapper<?>> em : this.responseExceptionMappers) {
            this.handleMapper(candidates, em, paramType, m, ResponseExceptionMapper.class, true);
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ProviderFactory.ClassComparator(paramType));
        return (ResponseExceptionMapper)candidates.get(0);
    }

    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.clientRequestFilters.clear();
        this.clientResponseFilters.clear();
    }

    public List<ProviderInfo<ClientRequestFilter>> getClientRequestFilters() {
        return Collections.unmodifiableList(this.clientRequestFilters);
    }

    public List<ProviderInfo<ClientResponseFilter>> getClientResponseFilters() {
        return Collections.unmodifiableList(this.clientResponseFilters);
    }

    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }
}

