/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="/token")
public class AccessTokenService
extends AbstractOAuthService {
    private List<AccessTokenGrantHandler> grantHandlers = Collections.emptyList();
    private boolean writeCustomErrors;

    public void setWriteCustomErrors(boolean write) {
        this.writeCustomErrors = write;
    }

    public void setGrantHandlers(List<AccessTokenGrantHandler> handlers) {
        this.grantHandlers = handlers;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleTokenRequest(MultivaluedMap<String, String> params) {
        ServerAccessToken serverToken;
        block6: {
            Client client = this.authenticateClientIfNeeded(params);
            AccessTokenGrantHandler handler = this.findGrantHandler(params);
            if (handler == null) {
                return this.createErrorResponse(params, "unsupported_grant_type");
            }
            serverToken = null;
            try {
                serverToken = handler.createAccessToken(client, params);
            }
            catch (OAuthServiceException ex) {
                OAuthError customError = ex.getError();
                if (!this.writeCustomErrors || customError == null) break block6;
                return this.createErrorResponseFromBean(customError);
            }
        }
        if (serverToken == null) {
            return this.createErrorResponse(params, "invalid_grant");
        }
        ClientAccessToken clientToken = new ClientAccessToken(serverToken.getTokenType(), serverToken.getTokenKey());
        clientToken.setRefreshToken(serverToken.getRefreshToken());
        if (this.isWriteOptionalParameters()) {
            clientToken.setExpiresIn(serverToken.getExpiresIn());
            List<OAuthPermission> perms = serverToken.getScopes();
            if (!perms.isEmpty()) {
                clientToken.setApprovedScope(OAuthUtils.convertPermissionsToScope(perms));
            }
            clientToken.setParameters(serverToken.getParameters());
        }
        return Response.ok((Object)clientToken).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").build();
    }

    private Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        Client client = null;
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        if (params.containsKey((Object)"client_id")) {
            client = this.getAndValidateClient((String)params.getFirst((Object)"client_id"), (String)params.getFirst((Object)"client_secret"));
        } else if (sc.getUserPrincipal() != null) {
            Principal p = sc.getUserPrincipal();
            String scheme = sc.getAuthenticationScheme();
            if ("Basic".equalsIgnoreCase(scheme)) {
                client = this.getClient(p.getName());
            } else {
                Object clientIdProp = this.getMessageContext().get((Object)"client_id");
                if (clientIdProp != null) {
                    client = this.getClient(clientIdProp.toString());
                }
            }
        } else {
            String[] parts = AuthorizationUtils.getAuthorizationParts(this.getMessageContext());
            if ("Basic".equalsIgnoreCase(parts[0])) {
                String[] authInfo = AuthorizationUtils.getBasicAuthParts(parts[1]);
                client = this.getAndValidateClient(authInfo[0], authInfo[1]);
            }
        }
        if (client == null) {
            throw new NotAuthorizedException(Response.status((int)401).build());
        }
        return client;
    }

    private Client getAndValidateClient(String clientId, String clientSecret) {
        Client client = this.getClient(clientId);
        if (clientSecret == null || !client.getClientId().equals(clientId) || !client.getClientSecret().equals(clientSecret)) {
            throw new NotAuthorizedException(Response.status((int)401).build());
        }
        return client;
    }

    protected AccessTokenGrantHandler findGrantHandler(MultivaluedMap<String, String> params) {
        String grantType = (String)params.getFirst((Object)"grant_type");
        if (grantType != null) {
            AuthorizationCodeGrantHandler handler;
            for (AccessTokenGrantHandler handler2 : this.grantHandlers) {
                if (!handler2.getSupportedGrantTypes().contains(grantType)) continue;
                return handler2;
            }
            if (this.grantHandlers.size() == 0 && (handler = new AuthorizationCodeGrantHandler()).getSupportedGrantTypes().contains(grantType)) {
                handler.setDataProvider((AuthorizationCodeDataProvider)super.getDataProvider());
                return handler;
            }
        }
        return null;
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromBean(OAuthError errorBean) {
        return Response.status((int)400).entity((Object)errorBean).build();
    }

    protected Client getClient(String clientId) {
        Client client = null;
        try {
            client = this.getValidClient(clientId);
        }
        catch (OAuthServiceException oAuthServiceException) {
            // empty catch block
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid");
        }
        return client;
    }
}

