/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.common.openapi;

import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;

public final class DefaultApplicationFactory {
    private DefaultApplicationFactory() {
    }

    public static Application createApplicationOrDefault(Server server, ServerProviderFactory factory, JAXRSServiceFactoryBean sfb, Bus bus, Set<String> resourcePackages, boolean scan) {
        ApplicationInfo appInfo = null;
        if (!scan && (appInfo = factory.getApplicationProvider()) == null) {
            appInfo = DefaultApplicationFactory.createApplicationInfo(sfb, resourcePackages, bus);
            server.getEndpoint().put((Object)Application.class.getName(), (Object)appInfo);
        }
        return appInfo == null ? null : (Application)appInfo.getProvider();
    }

    public static ApplicationInfo createApplicationInfoOrDefault(Server server, ServerProviderFactory factory, JAXRSServiceFactoryBean sfb, Bus bus, boolean scan) {
        ApplicationInfo appInfo = null;
        if (!scan && (appInfo = factory.getApplicationProvider()) == null) {
            HashSet serviceClasses = new HashSet();
            for (ClassResourceInfo cri : sfb.getClassResourceInfo()) {
                serviceClasses.add(cri.getServiceClass());
            }
            appInfo = DefaultApplicationFactory.createApplicationInfo(serviceClasses, bus);
            server.getEndpoint().put((Object)Application.class.getName(), (Object)appInfo);
        }
        return appInfo;
    }

    public static ApplicationInfo createApplicationInfo(Set<Class<?>> serviceClasses, Bus bus) {
        return new ApplicationInfo(DefaultApplicationFactory.createApplication(serviceClasses), bus);
    }

    public static ApplicationInfo createApplicationInfo(JAXRSServiceFactoryBean sfb, Set<String> resourcePackages, Bus bus) {
        return new ApplicationInfo(DefaultApplicationFactory.createApplication(sfb.getClassResourceInfo(), resourcePackages), bus);
    }

    public static Application createApplication(Set<Class<?>> serviceClasses) {
        return new DefaultApplication(serviceClasses);
    }

    public static Application createApplication(List<ClassResourceInfo> cris, Set<String> resourcePackages) {
        return new DefaultApplication(cris, resourcePackages);
    }

    protected static class DefaultApplication
    extends Application {
        private final Set<Class<?>> serviceClasses;

        DefaultApplication(Set<Class<?>> serviceClasses) {
            this.serviceClasses = serviceClasses;
        }

        DefaultApplication(List<ClassResourceInfo> cris, Set<String> resourcePackages) {
            this.serviceClasses = cris.stream().map(AbstractResourceInfo::getServiceClass).filter(cls -> resourcePackages == null || resourcePackages.isEmpty() || resourcePackages.stream().anyMatch(pkg -> cls.getPackage().getName().startsWith((String)pkg))).collect(Collectors.toSet());
        }

        public Set<Class<?>> getClasses() {
            return this.serviceClasses;
        }
    }
}

