/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingTokensBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public SupportingTokensBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SUPPORTING_TOKENS, SP11Constants.SIGNED_SUPPORTING_TOKENS, SP11Constants.ENDORSING_SUPPORTING_TOKENS, SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        QName name = DOMUtils.getElementQName((Element)element);
        SupportingToken supportingToken = null;
        if (SP11Constants.SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SUPPORTING, SP11Constants.INSTANCE, this.builder);
        } else if (SP11Constants.SIGNED_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED, SP11Constants.INSTANCE, this.builder);
        } else if (SP11Constants.ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENDORSING, SP11Constants.INSTANCE, this.builder);
        } else if (SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS.equals(name)) {
            supportingToken = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENDORSING, SP11Constants.INSTANCE, this.builder);
        }
        Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)element));
        policy = policy.normalize(this.builder.getPolicyRegistry(), false);
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), supportingToken);
        }
        return supportingToken;
    }

    private void processAlternative(List<Assertion> assertions, SupportingToken supportingToken) {
        for (Assertion primitive : assertions) {
            QName qname = primitive.getName();
            String localName = qname.getLocalPart();
            if ("AlgorithmSuite".equals(localName)) {
                supportingToken.setAlgorithmSuite((AlgorithmSuite)primitive);
                continue;
            }
            if ("SignedParts".equals(localName)) {
                supportingToken.setSignedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if ("SignedElements".equals(localName)) {
                supportingToken.setSignedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if ("EncryptedParts".equals(localName)) {
                supportingToken.setEncryptedParts((SignedEncryptedParts)primitive);
                continue;
            }
            if ("EncryptedElements".equals(localName)) {
                supportingToken.setEncryptedElements((SignedEncryptedElements)primitive);
                continue;
            }
            if (!(primitive instanceof Token)) continue;
            supportingToken.addToken((Token)primitive);
            ((Token)primitive).setSupportingToken(supportingToken);
        }
    }
}

