/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.javascript;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.wsdl.Definition;
import org.apache.cxf.Bus;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.validator.ServiceValidator;
import org.apache.cxf.tools.wsdlto.WSDLToJavaContainer;
import org.apache.cxf.tools.wsdlto.core.AbstractWSDLBuilder;
import org.apache.cxf.tools.wsdlto.core.FrontEndProfile;
import org.apache.cxf.tools.wsdlto.core.PluginLoader;
import org.apache.cxf.tools.wsdlto.javascript.WSDLToJavaScriptProcessor;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptContainer
extends WSDLToJavaContainer {
    private static final String TOOL_NAME = "wsdl2js";
    private static final String SERVICE_VALIDATOR = "META-INF/tools.service.validator.xml";

    public JavaScriptContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public Set<String> getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("jspackageprefix");
        set.add("beans");
        return set;
    }

    public WSDLConstants.WSDLVersion getWSDLVersion() {
        String version = (String)this.context.get("wsdlversion");
        return WSDLConstants.getVersion((String)version);
    }

    public void execute() throws ToolException {
        if (this.hasInfoOption()) {
            return;
        }
        this.buildToolContext();
        this.validate(this.context);
        WSDLConstants.WSDLVersion version = this.getWSDLVersion();
        String wsdlURL = (String)this.context.get("wsdlurl");
        List serviceList = (ArrayList)this.context.get("serviceList");
        if (serviceList == null) {
            serviceList = new ArrayList();
            PluginLoader pluginLoader = PluginLoader.newInstance();
            FrontEndProfile frontend = pluginLoader.getFrontEndProfile("jaxws");
            if (version == WSDLConstants.WSDLVersion.WSDL11) {
                AbstractWSDLBuilder builder = frontend.getWSDLBuilder();
                builder.setContext(this.context);
                builder.setBus(this.getBus());
                this.context.put(Bus.class, (Object)this.getBus());
                builder.build(URIParserUtil.getAbsoluteURI((String)wsdlURL));
                builder.customize();
                Definition definition = builder.getWSDLModel();
                this.context.put(Definition.class, (Object)definition);
                builder.validate(definition);
                WSDLServiceBuilder serviceBuilder = new WSDLServiceBuilder(this.getBus());
                String serviceName = (String)this.context.get("servicename");
                if (serviceName != null) {
                    List services = serviceBuilder.buildServices(definition, this.getServiceQName(definition));
                    serviceList.addAll(services);
                } else {
                    serviceList = definition.getServices().size() > 0 ? serviceBuilder.buildServices(definition) : serviceBuilder.buildMockServices(definition);
                }
            }
        }
        LinkedHashMap interfaces = new LinkedHashMap();
        ServiceInfo service0 = (ServiceInfo)serviceList.get(0);
        SchemaCollection schemaCollection = service0.getXmlSchemaCollection();
        this.context.put("xmlSchemaCollection", (Object)schemaCollection);
        this.context.put("portTypeMap", interfaces);
        this.context.put(ClassCollector.class, (Object)new ClassCollector());
        WSDLToJavaScriptProcessor processor = new WSDLToJavaScriptProcessor();
        for (ServiceInfo service : serviceList) {
            this.context.put(ServiceInfo.class, (Object)service);
            this.validate(service);
            processor.setEnvironment(this.context);
            processor.process();
        }
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        try {
            if (this.getArgument() != null) {
                super.execute(exitOnFinish);
            }
            this.execute();
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
        finally {
            this.tearDown();
        }
    }

    public void setNamespaceJavascriptPrefixes(ToolContext env) {
        HashMap<String, String> nsPrefixMap = new HashMap<String, String>();
        if (env.get("jspackageprefix") != null) {
            String[] pns = null;
            try {
                pns = (String[])env.get("jspackageprefix");
            }
            catch (ClassCastException e) {
                Message msg = new Message("INVALID_PREFIX_MAPPING", LOG, new Object[]{env.get("jspackageprefix")});
                throw new ToolException(msg);
            }
            for (String jsprefix : pns) {
                int pos = jsprefix.indexOf("=");
                if (pos == -1) continue;
                String ns = jsprefix.substring(0, pos);
                jsprefix = jsprefix.substring(pos + 1);
                nsPrefixMap.put(ns, jsprefix);
            }
            env.put("javascriptPrefixMap", nsPrefixMap);
        }
    }

    public void validate(ToolContext env) throws ToolException {
        String[] bindingFiles;
        File dir;
        String clsdir;
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir2 = new File(outdir);
            if (!dir2.exists() && !dir2.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
            if (!dir2.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
        }
        if (env.optionSet("compile") && (clsdir = (String)env.get("classdir")) != null && !(dir = new File(clsdir)).exists() && !dir.mkdirs()) {
            Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{clsdir});
            throw new ToolException(msg);
        }
        String wsdl = (String)env.get("wsdlurl");
        if (StringUtils.isEmpty((String)wsdl)) {
            Message msg = new Message("NO_WSDL_URL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        env.put("wsdlurl", (Object)URIParserUtil.normalize((String)wsdl));
        try {
            bindingFiles = (String[])env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            bindingFiles[i] = URIParserUtil.getAbsoluteURI((String)bindingFiles[i]);
        }
        env.put("binding", (Object)bindingFiles);
    }

    public void buildToolContext() {
        this.context = this.getContext();
        this.context.addParameters(this.getParametersMap(this.getArrayKeys()));
        if (this.context.get("outputdir") == null) {
            this.context.put("outputdir", (Object)".");
        }
        if (!this.context.containsKey("wsdlversion")) {
            this.context.put("wsdlversion", (Object)"1.1");
        }
        this.context.put("suppressWarnings", (Object)true);
        this.setNamespaceJavascriptPrefixes(this.context);
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }

    public void validate(ServiceInfo service) throws ToolException {
        for (ServiceValidator validator : this.getServiceValidators()) {
            service.setProperty(ToolContext.class.getName(), (Object)this.context);
            validator.setService(service);
            if (validator.isValid()) continue;
            throw new ToolException(validator.getErrorMessage());
        }
    }

    public List<ServiceValidator> getServiceValidators() {
        ArrayList<ServiceValidator> validators = new ArrayList<ServiceValidator>();
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)SERVICE_VALIDATOR, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (Object element : initialExtensions.values()) {
            String validatorClass = (String)element;
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found service validator : " + validatorClass);
                }
                ServiceValidator validator = (ServiceValidator)Class.forName(validatorClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
                validators.add(validator);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
        return validators;
    }
}

