/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.util.Bits$;
import org.apache.daffodil.util.LocalStack;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.MStackOf;
import org.apache.daffodil.util.Maybe;
import org.apache.daffodil.util.Maybe$;
import org.apache.daffodil.util.MaybeULong$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5w!\u0002\u001c8\u0011\u0003\u0001e!\u0002\"8\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005\"\u0002'\u0002\t\u0003i\u0005B\u0002'\u0002\t\u0003\u00119\f\u0003\u0004M\u0003\u0011\u0005!Q\u0018\u0004\u0005\u0005^\u0012q\n\u0003\u0005T\r\t\u0015\r\u0011\"\u0001U\u0011!AfA!A!\u0002\u0013)\u0006\"\u0002&\u0007\t\u0013I\u0006\"B.\u0007\t\u0003b\u0006bB3\u0007\u0005\u0004%)E\u001a\u0005\u0007U\u001a\u0001\u000bQB4\t\u000f-4!\u0019!C\u0001Y\"11O\u0002Q\u0001\n5Dq\u0001\u001e\u0004C\u0002\u0013\u0005Q\u000f\u0003\u0004z\r\u0001\u0006IA\u001e\u0005\u0006u\u001a!)e\u001f\u0005\b\u0003\u000f1AQIA\u0005\u0011\u001d\t\u0019B\u0002C\u0001\u0003+Aq!!\t\u0007\t\u0003\n\u0019\u0003C\u0004\u00020\u0019!\t!!\r\t\u000f\u0005]b\u0001\"\u0001\u0002:!9\u0011q\u0007\u0004\u0005\u0002\u0005m\u0003bBA3\r\u0011%\u0011q\r\u0005\b\u0003_2A\u0011AA9\u0011\u001d\tYH\u0002C\u0001\u0003{Bq!a\"\u0007\t\u0003\tI\tC\u0005\u0002\u0012\u001a\u0011\r\u0011\"\u0003\u0002\u0014\"A\u0011Q\u0013\u0004!\u0002\u0013\tY\u0004C\u0004\u0002\u0018\u001a!\t!!'\t\u000f\u0005=f\u0001\"\u0003\u00022\"9\u00111\u0018\u0004\u0005\u0002\u0005u\u0006bBAh\r\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003/4AQAAm\u0011\u001d\tyN\u0002C\u0001\u0003CDq!a:\u0007\t\u0003\tI\u000fC\u0004\u0003\u0012\u0019!IAa\u0005\t\u000f\t]a\u0001\"\u0001\u0003\u001a!9!Q\u0004\u0004\u0005\u0002\t}\u0001b\u0002B\u0012\r\u0011\u0005#Q\u0005\u0005\b\u0005[1A\u0011\tB\u0018\u0011\u001d\u0011)D\u0002C\u0001\u0005oAqA!\u000f\u0007\t\u000b\u0011Y\u0004C\u0004\u0003J\u0019!)Aa\u0013\t\u0015\tEc\u0001#b\u0001\n\u0003\u0011\u0019\u0006C\u0004\u0003b\u0019!\tAa\u0019\t\u000f\t%d\u0001\"\u0001\u0003l!I!\u0011\u0011\u0004C\u0002\u0013%!1\u0011\u0005\t\u0005\u00173\u0001\u0015!\u0003\u0003\u0006\"9!Q\u0012\u0004\u0005\u0002\t=\u0005b\u0002BL\r\u0011\u0005#\u0011\u0014\u0005\b\u0005?3A\u0011\u0001BQ\u0011\u001d\u0011iK\u0002C\u0001\u0005_\u000b!$\u00138qkR\u001cv.\u001e:dK\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6T!\u0001O\u001d\u0002\u0005%|'B\u0001\u001e<\u0003!!\u0017M\u001a4pI&d'B\u0001\u001f>\u0003\u0019\t\u0007/Y2iK*\ta(A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002B\u00035\tqG\u0001\u000eJ]B,HoU8ve\u000e,G)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fWn\u0005\u0002\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00079\u0013\u0019\f\u0005\u0002B\rM\u0019a\u0001\u0012)\u0011\u0005\u0005\u000b\u0016B\u0001*8\u0005a!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017*\u001c9m\u001b&D\u0018N\\\u0001\fS:\u0004X\u000f^*pkJ\u001cW-F\u0001V!\t\te+\u0003\u0002Xo\tY\u0011J\u001c9viN{WO]2f\u00031Ig\u000e];u'>,(oY3!)\tq%\fC\u0003T\u0013\u0001\u0007Q+\u0001\u0005u_N#(/\u001b8h)\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u0011a\u0017M\\4\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0007\r\u001cH/F\u0001h!\t\t\u0005.\u0003\u0002jo\tIQ*\u0019:l'R\fG/Z\u0001\u0005GN$\b%A\u0005nCJ\\7\u000b^1dWV\tQ\u000eE\u0002oc\u001el\u0011a\u001c\u0006\u0003af\nA!\u001e;jY&\u0011!o\u001c\u0002\t\u001bN#\u0018mY6PM\u0006QQ.\u0019:l'R\f7m\u001b\u0011\u0002\u00115\f'o\u001b)p_2,\u0012A\u001e\t\u0003\u0003^L!\u0001_\u001c\u0003\u00115\u000b'o\u001b)p_2\f\u0011\"\\1sWB{w\u000e\u001c\u0011\u0002\u0011\tLG\u000fU8ta\t,\u0012\u0001 \t\u0003\u000bvL!A $\u0003\t1{gn\u001a\u0015\u0004#\u0005\u0005\u0001cA#\u0002\u0004%\u0019\u0011Q\u0001$\u0003\r%tG.\u001b8f\u0003)\u0011\u0017\u000e\u001e'j[&$\bGY\u000b\u0003\u0003\u0017\u00012A\\A\u0007\u0013\r\tya\u001c\u0002\u000b\u001b\u0006L(-Z+M_:<\u0007f\u0001\n\u0002\u0002\u0005Y1/\u001a;CSR\u0004vn\u001d\u0019c)\u0011\t9\"!\b\u0011\u0007\u0015\u000bI\"C\u0002\u0002\u001c\u0019\u0013A!\u00168ji\"1\u0011qD\nA\u0002q\f1B\\3x\u0005&$\bk\\:1E\u0006i1/\u001a;CSRd\u0015.\\5ua\t$B!!\n\u0002,A\u0019Q)a\n\n\u0007\u0005%bIA\u0004C_>dW-\u00198\t\u000f\u00055B\u00031\u0001\u0002\f\u0005ia.Z<CSRd\u0015.\\5ua\t\fqB]3tKR\u0014\u0015\u000e\u001e'j[&$\bG\u0019\u000b\u0005\u0003/\t\u0019\u0004C\u0004\u00026U\u0001\r!a\u0003\u0002\u001fM\fg/\u001a3CSRd\u0015.\\5ua\t\fAbZ3u\u0005f$X-\u0011:sCf$b!a\u000f\u0002H\u0005E\u0003#B#\u0002>\u0005\u0005\u0013bAA \r\n)\u0011I\u001d:bsB\u0019Q)a\u0011\n\u0007\u0005\u0015cI\u0001\u0003CsR,\u0007bBA%-\u0001\u0007\u00111J\u0001\u000fE&$H*\u001a8hi\"4%o\\72!\r)\u0015QJ\u0005\u0004\u0003\u001f2%aA%oi\"9\u00111\u000b\fA\u0002\u0005U\u0013!\u00024j]\u001a|\u0007cA!\u0002X%\u0019\u0011\u0011L\u001c\u0003\u0015\u0019{'/\\1u\u0013:4w\u000e\u0006\u0005\u0002\u0018\u0005u\u0013qLA1\u0011\u001d\tIe\u0006a\u0001\u0003\u0017Bq!a\u0015\u0018\u0001\u0004\t)\u0006C\u0004\u0002d]\u0001\r!a\u000f\u0002\u000b\u0005\u0014(/Y=\u0002\u001b\u0019LG\u000e\u001c\"zi\u0016\f%O]1z)!\t9\"!\u001b\u0002l\u00055\u0004bBA21\u0001\u0007\u00111\b\u0005\b\u0003\u0013B\u0002\u0019AA&\u0011\u001d\t\u0019\u0006\u0007a\u0001\u0003+\nqbZ3u\u0005&t\u0017M]=E_V\u0014G.\u001a\u000b\u0005\u0003g\nI\bE\u0002F\u0003kJ1!a\u001eG\u0005\u0019!u.\u001e2mK\"9\u00111K\rA\u0002\u0005U\u0013AD4fi\nKg.\u0019:z\r2|\u0017\r\u001e\u000b\u0005\u0003\u007f\n)\tE\u0002F\u0003\u0003K1!a!G\u0005\u00151En\\1u\u0011\u001d\t\u0019F\u0007a\u0001\u0003+\nQbZ3u'&<g.\u001a3M_:<G#\u0002?\u0002\f\u0006=\u0005bBAG7\u0001\u0007\u00111J\u0001\u0013E&$H*\u001a8hi\"4%o\\72)>4D\u0007C\u0004\u0002Tm\u0001\r!!\u0016\u0002\u00131|gnZ!se\u0006LXCAA\u001e\u0003)awN\\4BeJ\f\u0017\u0010I\u0001\u0010O\u0016$XK\\:jO:,G\rT8oOR1\u00111TAV\u0003[\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0005v]NLwM\\3e\u0015\t\t)+A\u0004qCN\u001cXM]1\n\t\u0005%\u0016q\u0014\u0002\u0006+2{gn\u001a\u0005\b\u0003\u001bs\u0002\u0019AA&\u0011\u001d\t\u0019F\ba\u0001\u0003+\n\u0011%\u00193kkN$()[4J]R\f%O]1z/&$\bN\u0012:bO6,g\u000e\u001e\"zi\u0016$\u0002\"a\u0006\u00024\u0006U\u0016\u0011\u0018\u0005\b\u0003Gz\u0002\u0019AA\u001e\u0011\u001d\t9l\ba\u0001\u0003\u0017\naB\u001a:bO6,g\u000e\u001e'f]\u001e$\b\u000eC\u0004\u0002T}\u0001\r!!\u0016\u0002\u001f\u001d,GoU5h]\u0016$')[4J]R$b!a0\u0002L\u00065\u0007\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015\u0017-\u0001\u0003nCRD\u0017\u0002BAe\u0003\u0007\u0014!BQ5h\u0013:$XmZ3s\u0011\u001d\tI\u0005\ta\u0001\u0003\u0017Bq!a\u0015!\u0001\u0004\t)&A\thKR,fn]5h]\u0016$')[4J]R$b!a0\u0002T\u0006U\u0007bBA%C\u0001\u0007\u00111\n\u0005\b\u0003'\n\u0003\u0019AA+\u0003II7\u000fR3gS:,GMR8s\u0019\u0016tw\r\u001e5\u0015\t\u0005\u0015\u00121\u001c\u0005\u0007\u0003;\u0014\u0003\u0019\u0001?\u0002\u000b9\u0014\u0015\u000e^:\u0002\tM\\\u0017\u000e\u001d\u000b\u0007\u0003K\t\u0019/!:\t\r\u0005u7\u00051\u0001}\u0011\u001d\t\u0019f\ta\u0001\u0003+\nA!\\1sWR!\u00111^A}!\u0011\ti/a=\u000f\u0007\u0005\u000by/C\u0002\u0002r^\nq\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0005\u0005\u0003k\f9P\u0001\u0003NCJ\\'bAAyo!9\u00111 \u0013A\u0002\u0005u\u0018a\u0003:fcV,7\u000f^8s\u0013\u0012\u0003B!a@\u0003\u000e9!!\u0011\u0001B\u0005!\r\u0011\u0019AR\u0007\u0003\u0005\u000bQ1Aa\u0002@\u0003\u0019a$o\\8u}%\u0019!1\u0002$\u0002\rA\u0013X\rZ3g\u0013\r!'q\u0002\u0006\u0004\u0005\u00171\u0015\u0001\u0005:fY\u0016\f7/Z+oi&dW*\u0019:l)\r9'Q\u0003\u0005\b\u0003O,\u0003\u0019AAv\u0003\u0015\u0011Xm]3u)\u0011\t9Ba\u0007\t\u000f\u0005\u001dh\u00051\u0001\u0002l\u00069A-[:dCJ$G\u0003BA\f\u0005CAq!a:(\u0001\u0004\tY/A\u0004nCJ\\\u0007k\\:\u0016\u0005\t\u001d\u0002\u0003BAw\u0005SIAAa\u000b\u0002x\n9Q*\u0019:l!>\u001c\u0018\u0001\u0003:fg\u0016$\bk\\:\u0015\t\u0005]!\u0011\u0007\u0005\b\u0005gI\u0003\u0019\u0001B\u0014\u0003\u0005i\u0017\u0001\u0007<bY&$\u0017\r^3GS:\fGn\u0015;sK\u0006l7\u000b^1uKV\u0011\u0011qC\u0001\nO\u0016$8\u000b\u001e:j]\u001e$bA!\u0010\u0003D\t\u001d\u0003#\u00028\u0003@\u0005u\u0018b\u0001B!_\n)Q*Y=cK\"1!QI\u0016A\u0002q\faA\\\"iCJ\u001c\bbBA*W\u0001\u0007\u0011QK\u0001\u000eO\u0016$8k\\7f'R\u0014\u0018N\\4\u0015\r\tu\"Q\nB(\u0011\u0019\u0011)\u0005\fa\u0001y\"9\u00111\u000b\u0017A\u0002\u0005U\u0013AD:lSB\u001c\u0005.\u0019:Ck\u001a4WM]\u000b\u0003\u0005+\u0002BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057\n\u0017a\u00018j_&!!q\fB-\u0005)\u0019\u0005.\u0019:Ck\u001a4WM]\u0001\ng.L\u0007o\u00115beN$b!!\n\u0003f\t\u001d\u0004B\u0002B#]\u0001\u0007A\u0010C\u0004\u0002T9\u0002\r!!\u0016\u0002\u00131|wn[5oO\u0006#HCBA\u0013\u0005[\u0012y\bC\u0004\u0003p=\u0002\rA!\u001d\u0002\u000f5\fGo\u00195feB!!1\u000fB>\u001b\t\u0011)H\u0003\u0003\u0003x\te\u0014!\u0002:fO\u0016D(B\u00019b\u0013\u0011\u0011iH!\u001e\u0003\u000f5\u000bGo\u00195fe\"9\u00111K\u0018A\u0002\u0005U\u0013\u0001D2iCJLE/\u001a:bi>\u0014XC\u0001BC!\r\t%qQ\u0005\u0004\u0005\u0013;$AJ%oaV$8k\\;sG\u0016$\u0015\r^1J]B,Ho\u0015;sK\u0006l7\t[1s\u0013R,'/\u0019;pe\u0006i1\r[1s\u0013R,'/\u0019;pe\u0002\na\"Y:Ji\u0016\u0014\u0018\r^8s\u0007\"\f'/\u0006\u0002\u0003\u0012B!\u0011Q\u001eBJ\u0013\u0011\u0011)*a>\u0003\u0019\rC\u0017M]%uKJ\fGo\u001c:\u0002\u0019M,G\u000fR3ck\u001e<\u0017N\\4\u0015\t\u0005]!1\u0014\u0005\b\u0005;\u001b\u0004\u0019AA\u0013\u0003\u001d\u0019X\r\u001e;j]\u001e\f\u0001\u0002]1ti\u0012\u000bG/\u0019\u000b\u0005\u0005G\u0013I\u000b\u0005\u0003\u0003X\t\u0015\u0016\u0002\u0002BT\u00053\u0012!BQ=uK\n+hMZ3s\u0011\u001d\u0011Y\u000b\u000ea\u0001\u0003\u0017\nqB\u001c\"zi\u0016\u001c(+Z9vKN$X\rZ\u0001\u000bMV$XO]3ECR\fG\u0003\u0002BR\u0005cCqAa+6\u0001\u0004\tY\u0005C\u0004\u00036\u000e\u0001\r!a\u000f\u0002\u0013\tLH/Z!se\u0006LHc\u0001(\u0003:\"9!1\u0018\u0003A\u0002\t\r\u0016A\u00032zi\u0016\u0014UO\u001a4feR\u0019aJa0\t\u000f\t\u0005W\u00011\u0001\u0003D\u0006\u0011\u0011N\u001c\t\u0005\u0005\u000b\u0014I-\u0004\u0002\u0003H*\u0011\u0001(Y\u0005\u0005\u0005\u0017\u00149MA\u0006J]B,Ho\u0015;sK\u0006l\u0007")
public final class InputSourceDataInputStream
implements DataInputStreamImplMixin {
    private CharBuffer skipCharBuffer;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf<MarkState> markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private final InputSourceDataInputStreamCharIterator charIterator;
    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer;
    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile byte bitmap$0;

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    @Override
    public final boolean isAligned(int bitAlignment1b) {
        return DataInputStreamImplMixin.isAligned$(this, bitAlignment1b);
    }

    @Override
    public final boolean align(int bitAlignment1b, FormatInfo finfo) {
        return DataInputStreamImplMixin.align$(this, bitAlignment1b, finfo);
    }

    @Override
    public final long remainingBits() {
        return DataInputStreamImplMixin.remainingBits$(this);
    }

    @Override
    public final boolean areDebugging() {
        return DataStreamCommonImplMixin.areDebugging$(this);
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    @Override
    public final long bitPos1b() {
        return DataInputStream.bitPos1b$(this);
    }

    @Override
    public final long bytePos0b() {
        return DataInputStream.bytePos0b$(this);
    }

    @Override
    public final long bytePos1b() {
        return DataInputStream.bytePos1b$(this);
    }

    @Override
    public final long bitLimit1b() {
        return DataInputStream.bitLimit1b$(this);
    }

    @Override
    public final boolean setBitLimit1b(long bitLimit1b) {
        return DataInputStream.setBitLimit1b$(this, bitLimit1b);
    }

    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.withLocalCharBuffer = LocalBufferMixin.withLocalCharBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.withLocalCharBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.withLocalCharBuffer$lzycompute() : this.withLocalCharBuffer;
    }

    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withLocalByteBuffer = LocalBufferMixin.withLocalByteBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withLocalByteBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.withLocalByteBuffer$lzycompute() : this.withLocalByteBuffer;
    }

    private String logID$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? ((Object)BoxesRunTime.boxToLong((long)MaybeULong$.MODULE$.get$extension(bl0b))).toString() : "none";
        String str = new StringBuilder(35).append("DataInputStream(bitPos=").append(bp0b).append(", bitLimit=").append(bl0b1).append(")").toString();
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        boolean bl;
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() < bytesNeeded) {
            throw Assert$.MODULE$.abort("Usage error: scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        block4: {
            boolean isUnaligned = !this.isAligned(8);
            int fragmentBits = bitLengthFrom1 % 8;
            int bytesToFill = (bitLengthFrom1 + 7) / 8;
            this.inputSource().get(array, 0, bytesToFill);
            if (isUnaligned) {
                int index;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null);
                int bitOffset0b = (int)(this.bitPos0b() % 8L);
                int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
                int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte((long)this.inputSource().get()) : 0;
                int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
                int nxtBitMask = ~curBitMask & 0xFF;
                int curShift = bitOffset0b;
                int nxtShift = 8 - bitOffset0b;
                int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
                int stopIndex = bytesToFill - 1;
                for (index = 0; index < stopIndex; ++index) {
                    int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                    array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, nxtByte, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
                    curByte = nxtByte;
                }
                array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, arrayOverflow, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
            }
            if (fragmentBits > 0) {
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                int mask = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
                int lastIndex = bytesToFill - 1;
                int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)(lastByte & mask));
            }
            if (bitLengthFrom1 <= 8) break block4;
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        void var3_3;
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return (float)var3_3;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    private byte[] longArray() {
        return this.longArray;
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(bitLengthFrom1To64)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1To64);
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray(), bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray()[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray()[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray()[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return res;
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
        } else {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                int lastIndex = array.length - 1;
                byte lastByte = array[lastIndex];
                int shifted = lastByte << 8 - fragmentLength;
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
            ByteBuffer bb = ByteBuffer.wrap(array);
            Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
        }
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        BigInteger bigInteger;
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            bigInteger = BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        } else {
            byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
            int fragmentLength = bitLengthFrom1 % 8;
            if (fragmentLength > 0) {
                this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
                int shift = 8 - fragmentLength;
                bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
            }
            bigInteger = new BigInteger(bytes);
        }
        return bigInteger;
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        boolean bl;
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            bl = false;
        } else {
            long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
            long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
            bl = this.inputSource().areBytesAvailable(moreBytesNeeded);
        }
        return bl;
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.Mark mark(String requestorID) {
        void var2_2;
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push((Object)m);
        this.inputSource().lockPosition(m.bytePos0b());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        void var2_2;
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.abort("Usage error: InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.abort("Usage error: mark.!=(null)");
        }
        MarkState current = (MarkState)this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = (MarkState)this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return var2_2;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    @Override
    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        return !aligned ? Maybe$.MODULE$.Nope() : ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        return !aligned ? Maybe$.MODULE$.Nope() : ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getSomeString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    private CharBuffer skipCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.skipCharBuffer = CharBuffer.allocate(32);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.skipCharBuffer;
    }

    public CharBuffer skipCharBuffer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.skipCharBuffer$lzycompute() : this.skipCharBuffer;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean bl;
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            boolean skippedAllNChars;
            long remainingCharsToSkip;
            int numDecoded;
            boolean keepGoing = true;
            for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
                long charsToSkip = Math.min(remainingCharsToSkip, (long)this.skipCharBuffer().capacity());
                this.skipCharBuffer().position(0);
                this.skipCharBuffer().limit((int)charsToSkip);
                BitsCharsetDecoder qual$1 = finfo.decoder();
                InputSourceDataInputStream x$1 = this;
                FormatInfo x$2 = finfo;
                CharBuffer x$3 = this.skipCharBuffer();
                LongBuffer x$4 = qual$1.decode$default$4();
                numDecoded = qual$1.decode(x$1, x$2, x$3, x$4);
                if (numDecoded != 0) continue;
                keepGoing = false;
            }
            boolean bl2 = skippedAllNChars = remainingCharsToSkip == 0L;
            if (!skippedAllNChars) {
                this.setBitPos0b(startingBitPos);
            }
            bl = skippedAllNChars;
        }
        return bl;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean bl;
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
            CharBuffer regexMatchBuffer = finfo.regexMatchBuffer();
            LongBuffer regexMatchBitPositionBuffer = finfo.regexMatchBitPositionBuffer();
            regexMatchBuffer.position(0);
            regexMatchBuffer.limit(0);
            regexMatchBitPositionBuffer.position(0);
            regexMatchBitPositionBuffer.limit(0);
            long startingBitPos = this.bitPos0b();
            boolean keepMatching = true;
            boolean isMatch = false;
            while (keepMatching) {
                regexMatchBuffer.position(regexMatchBuffer.limit());
                regexMatchBuffer.limit(regexMatchBufferLimit);
                regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
                regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
                int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
                boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
                regexMatchBuffer.flip();
                regexMatchBitPositionBuffer.flip();
                if (numDecoded > 0) {
                    matcher.reset(regexMatchBuffer);
                    isMatch = matcher.lookingAt();
                    boolean hitEnd = matcher.hitEnd();
                    boolean requireEnd = matcher.requireEnd();
                    if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                        if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                            keepMatching = false;
                            continue;
                        }
                        regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                        continue;
                    }
                    keepMatching = false;
                    continue;
                }
                keepMatching = false;
            }
            if (isMatch && matcher.end() != 0) {
                long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
                this.setBitPos0b(endingBitPos);
            } else {
                this.setBitPos0b(startingBitPos);
            }
            bl = isMatch;
        }
        return bl;
    }

    private InputSourceDataInputStreamCharIterator charIterator() {
        return this.charIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        void var1_1;
        InputSourceDataInputStreamCharIterator ci = this.charIterator();
        ci.reset();
        return var1_1;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, (long)nBytesRequested);
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(nBytesRequested);
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().bytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(long curByte, long nxtByte, int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    /*
     * WARNING - void declaration
     */
    private final long buildLongFromArray$1(int numBytes$1) {
        void var2_2;
        long l = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray()[i]);
        }
        return (long)var2_2;
    }

    public static final /* synthetic */ Object $anonfun$getString$1(InputSourceDataInputStream $this, long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        Object object;
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder qual$1 = finfo$1.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$1, x$3 = cb, x$4 = qual$1.decode$default$4());
        if ((long)numDecoded == nChars$1) {
            object = Maybe$.MODULE$.apply((Object)cb.flip().toString());
        } else {
            $this.setBitPos0b(startingBitPos$1);
            object = Maybe$.MODULE$.Nope();
        }
        return object;
    }

    public static final /* synthetic */ Object $anonfun$getSomeString$1(InputSourceDataInputStream $this, long nChars$2, FormatInfo finfo$2, long startingBitPos$2, LocalBufferMixin.LocalCharBuffer lcb) {
        Object object;
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$2);
        BitsCharsetDecoder qual$1 = finfo$2.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$2, x$3 = cb, x$4 = qual$1.decode$default$4());
        if (numDecoded > 0) {
            object = Maybe$.MODULE$.apply((Object)cb.flip().toString());
        } else {
            $this.setBitPos0b(startingBitPos$2);
            object = Maybe$.MODULE$.Nope();
        }
        return object;
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        DataInputStream.$init$(this);
        Logging.$init$((Logging)this);
        DataStreamCommonImplMixin.$init$(this);
        LocalBufferMixin.$init$(this);
        DataInputStreamImplMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }
}

