/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.NioBits;
import org.apache.datasketches.memory.StepBoolean;
import org.apache.datasketches.memory.UnsafeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;

final class AllocateDirect
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AllocateDirect.class);
    private final Deallocator deallocator;
    private final Cleaner cleaner;
    private final long nativeBaseOffset;

    AllocateDirect(long capacityBytes) {
        long nativeAddress;
        boolean pageAligned = NioBits.isPageAligned();
        long pageSize = NioBits.pageSize();
        long allocationSize = capacityBytes + (pageAligned ? pageSize : 0L);
        NioBits.reserveMemory(allocationSize, capacityBytes);
        try {
            nativeAddress = UnsafeUtil.unsafe.allocateMemory(allocationSize);
        }
        catch (OutOfMemoryError err) {
            NioBits.unreserveMemory(allocationSize, capacityBytes);
            throw err;
        }
        this.nativeBaseOffset = pageAligned && nativeAddress % pageSize != 0L ? (nativeAddress & (pageSize - 1L ^ 0xFFFFFFFFFFFFFFFFL)) + pageSize : nativeAddress;
        this.deallocator = new Deallocator(nativeAddress, allocationSize, capacityBytes);
        this.cleaner = Cleaner.create((Object)this, (Runnable)this.deallocator);
    }

    @Override
    public void close() {
        this.doClose();
    }

    boolean doClose() {
        try {
            if (this.deallocator.deallocate(false)) {
                this.cleaner.clean();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            BaseState.reachabilityFence(this);
        }
    }

    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    StepBoolean getValid() {
        return this.deallocator.getValid();
    }

    private static final class Deallocator
    implements Runnable {
        private final long nativeAddress;
        private final long allocationSize;
        private final long capacity;
        private final StepBoolean valid = new StepBoolean(true);

        private Deallocator(long nativeAddress, long allocationSize, long capacity) {
            BaseState.currentDirectMemoryAllocations_.incrementAndGet();
            BaseState.currentDirectMemoryAllocated_.addAndGet(capacity);
            this.nativeAddress = nativeAddress;
            this.allocationSize = allocationSize;
            this.capacity = capacity;
            assert (nativeAddress != 0L);
        }

        StepBoolean getValid() {
            return this.valid;
        }

        @Override
        public void run() {
            this.deallocate(true);
        }

        boolean deallocate(boolean calledFromCleaner) {
            if (this.valid.change()) {
                if (calledFromCleaner) {
                    LOG.warn("A WritableDirectHandle was not closed manually");
                }
                UnsafeUtil.unsafe.freeMemory(this.nativeAddress);
                NioBits.unreserveMemory(this.allocationSize, this.capacity);
                BaseState.currentDirectMemoryAllocations_.decrementAndGet();
                BaseState.currentDirectMemoryAllocated_.addAndGet(-this.capacity);
                return true;
            }
            return false;
        }
    }
}

