/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.MapHandle;
import org.apache.datasketches.memory.Prim;
import org.apache.datasketches.memory.UnsafeUtil;
import org.apache.datasketches.memory.Utf8CodingException;
import org.apache.datasketches.memory.Util;
import org.apache.datasketches.memory.WritableMemory;

public abstract class Memory
extends BaseState {
    Memory(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    public static Memory wrap(ByteBuffer byteBuf) {
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, true, byteBuf.order());
    }

    public static Memory wrap(ByteBuffer byteBuf, ByteOrder byteOrder) {
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, true, byteOrder);
    }

    public static MapHandle map(File file) throws IOException {
        return Memory.map(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static MapHandle map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        Util.zeroCheck(capacityBytes, "Capacity");
        Util.nullCheck(file, "file is null");
        Util.negativeCheck(fileOffsetBytes, "File offset is negative");
        return BaseWritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, true, byteOrder);
    }

    public abstract Memory region(long var1, long var3);

    public abstract Memory region(long var1, long var3, ByteOrder var5);

    public abstract Buffer asBuffer();

    public abstract Buffer asBuffer(ByteOrder var1);

    public abstract ByteBuffer unsafeByteBufferView(long var1, int var3);

    public static Memory wrap(boolean[] arr) {
        long lengthBytes = arr.length << (int)Prim.BOOLEAN.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(byte[] arr) {
        return Memory.wrap(arr, 0, arr.length, BaseState.nativeByteOrder);
    }

    public static Memory wrap(byte[] arr, ByteOrder byteOrder) {
        return Memory.wrap(arr, 0, arr.length, byteOrder);
    }

    public static Memory wrap(byte[] arr, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, arr.length);
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, byteOrder);
    }

    public static Memory wrap(char[] arr) {
        long lengthBytes = arr.length << (int)Prim.CHAR.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(short[] arr) {
        long lengthBytes = arr.length << (int)Prim.SHORT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(int[] arr) {
        long lengthBytes = arr.length << (int)Prim.INT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(long[] arr) {
        long lengthBytes = arr.length << (int)Prim.LONG.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(float[] arr) {
        long lengthBytes = arr.length << (int)Prim.FLOAT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public static Memory wrap(double[] arr) {
        long lengthBytes = arr.length << (int)Prim.DOUBLE.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, true, BaseState.nativeByteOrder);
    }

    public abstract boolean getBoolean(long var1);

    public abstract void getBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public abstract byte getByte(long var1);

    public abstract void getByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract char getChar(long var1);

    public abstract void getCharArray(long var1, char[] var3, int var4, int var5);

    public abstract int getCharsFromUtf8(long var1, int var3, Appendable var4) throws IOException, Utf8CodingException;

    public abstract int getCharsFromUtf8(long var1, int var3, StringBuilder var4) throws Utf8CodingException;

    public abstract double getDouble(long var1);

    public abstract void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract float getFloat(long var1);

    public abstract void getFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract int getInt(long var1);

    public abstract void getIntArray(long var1, int[] var3, int var4, int var5);

    public abstract long getLong(long var1);

    public abstract void getLongArray(long var1, long[] var3, int var4, int var5);

    public abstract short getShort(long var1);

    public abstract void getShortArray(long var1, short[] var3, int var4, int var5);

    public abstract int compareTo(long var1, long var3, Memory var5, long var6, long var8);

    public abstract void copyTo(long var1, WritableMemory var3, long var4, long var6);

    public abstract void writeTo(long var1, long var3, WritableByteChannel var5) throws IOException;
}

