/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

public abstract class WritableBuffer
extends Buffer {
    WritableBuffer(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    public static WritableBuffer wrap(ByteBuffer byteBuf) {
        return WritableBuffer.wrap(byteBuf, byteBuf.order());
    }

    public static WritableBuffer wrap(ByteBuffer byteBuf, ByteOrder byteOrder) {
        BaseWritableMemoryImpl wmem = BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, false, byteOrder);
        WritableBuffer wbuf = wmem.asWritableBufferImpl(false, byteOrder);
        wbuf.setStartPositionEnd(0L, byteBuf.position(), byteBuf.limit());
        return wbuf;
    }

    public abstract WritableBuffer writableDuplicate();

    public abstract WritableBuffer writableDuplicate(ByteOrder var1);

    public abstract WritableBuffer writableRegion();

    public abstract WritableBuffer writableRegion(long var1, long var3, ByteOrder var5);

    public abstract WritableMemory asWritableMemory();

    public abstract void putBoolean(boolean var1);

    public abstract void putBoolean(long var1, boolean var3);

    public abstract void putBooleanArray(boolean[] var1, int var2, int var3);

    public abstract void putByte(byte var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putByteArray(byte[] var1, int var2, int var3);

    public abstract void putChar(char var1);

    public abstract void putChar(long var1, char var3);

    public abstract void putCharArray(char[] var1, int var2, int var3);

    public abstract void putDouble(double var1);

    public abstract void putDouble(long var1, double var3);

    public abstract void putDoubleArray(double[] var1, int var2, int var3);

    public abstract void putFloat(float var1);

    public abstract void putFloat(long var1, float var3);

    public abstract void putFloatArray(float[] var1, int var2, int var3);

    public abstract void putInt(int var1);

    public abstract void putInt(long var1, int var3);

    public abstract void putIntArray(int[] var1, int var2, int var3);

    public abstract void putLong(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putLongArray(long[] var1, int var2, int var3);

    public abstract void putShort(short var1);

    public abstract void putShort(long var1, short var3);

    public abstract void putShortArray(short[] var1, int var2, int var3);

    public abstract Object getArray();

    public abstract void clear();

    public abstract void fill(byte var1);

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        return null;
    }
}

