/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.servlet.impl.produce;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.deltaspike.core.util.ClassUtils;

class ServletContextHolder {
    private static final Logger log = Logger.getLogger(ServletContextHolder.class.getName());
    private static final Map<ClassLoader, ServletContext> CONTEXT_BY_CLASSLOADER = Collections.synchronizedMap(new WeakHashMap());

    private ServletContextHolder() {
    }

    static void bind(ServletContext servletContext) {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        ServletContext existingContext = CONTEXT_BY_CLASSLOADER.put(classLoader, servletContext);
        if (existingContext != null) {
            throw new IllegalArgumentException("There is already a ServletContext associated with class loader: " + classLoader);
        }
    }

    static ServletContext get() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        ServletContext servletContext = CONTEXT_BY_CLASSLOADER.get(classLoader);
        if (servletContext == null) {
            throw new IllegalStateException("There is no ServletContext stored for class loader: " + classLoader);
        }
        return servletContext;
    }

    static void release() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        ServletContext removedContext = CONTEXT_BY_CLASSLOADER.remove(classLoader);
        if (removedContext == null) {
            log.warning("Cannot find a ServletContext to release for class loader: " + classLoader);
        }
    }
}

