/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;

public abstract class UserClass {
    public static final AllUsers ALL_USERS = new AllUsers();
    public static final ThisEntry THIS_ENTRY = new ThisEntry();
    public static final ParentOfEntry PARENT_OF_ENTRY = new ParentOfEntry();

    protected UserClass() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subtree
    extends UserClass {
        protected final Set<SubtreeSpecification> subtreeSpecifications;

        public Subtree(Set<SubtreeSpecification> subtreeSpecs) {
            this.subtreeSpecifications = Collections.unmodifiableSet(subtreeSpecs);
        }

        public Set<SubtreeSpecification> getSubtreeSpecifications() {
            return this.subtreeSpecifications;
        }

        public int hashCode() {
            int hash = 37;
            hash = hash * 17 + this.subtreeSpecifications.hashCode();
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Subtree) {
                Subtree that = (Subtree)o;
                return this.subtreeSpecifications.equals(that.subtreeSpecifications);
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("subtree { ");
            for (SubtreeSpecification ss : this.subtreeSpecifications) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                ss.toString(buffer);
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserGroup
    extends NamedUserClass {
        public UserGroup(Set<Dn> groupNames) {
            super(groupNames);
        }

        @Override
        public String toString() {
            return "userGroup " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    extends NamedUserClass {
        public Name(Set<Dn> usernames) {
            super(usernames);
        }

        @Override
        public String toString() {
            return "name " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NamedUserClass
    extends UserClass {
        protected final Set<Dn> names;

        protected NamedUserClass(Set<Dn> names) {
            this.names = names == null ? Collections.unmodifiableSet(new HashSet()) : Collections.unmodifiableSet(new HashSet<Dn>(names));
        }

        public Set<Dn> getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                Name that = (Name)o;
                return this.names.equals(that.names);
            }
            return false;
        }

        public int hashCode() {
            int result = 37;
            for (Dn dn : this.names) {
                result = result * 17 + dn.hashCode();
            }
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            buffer.append("{ ");
            for (Dn name : this.names) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append('\"');
                buffer.append(name.toString());
                buffer.append('\"');
            }
            buffer.append(" }");
            return buffer.toString();
        }
    }

    public static final class ParentOfEntry
    extends UserClass {
        private ParentOfEntry() {
        }

        public String toString() {
            return "parentOfEntry";
        }
    }

    public static final class ThisEntry
    extends UserClass {
        private ThisEntry() {
        }

        public String toString() {
            return "thisEntry";
        }
    }

    public static final class AllUsers
    extends UserClass {
        private AllUsers() {
        }

        public String toString() {
            return "allUsers";
        }
    }
}

