/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.cursor;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final E[] set;
    private final Comparator<E> comparator;
    private int index = -1;

    public SetCursor(Comparator<E> comparator, Set<E> set) {
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SetCursor {}", (Object)this);
        }
        this.comparator = comparator;
        this.set = set.toArray();
    }

    public SetCursor(Set<E> set) {
        this(null, set);
    }

    public SetCursor() {
        this(null, Collections.EMPTY_SET);
    }

    public SetCursor(Comparator<E> comparator) {
        this(comparator, Collections.EMPTY_SET);
    }

    @Override
    public boolean available() {
        return this.index >= 0 && this.index < this.set.length;
    }

    @Override
    public void before(E element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.set.length == 0) {
            return;
        }
        if (this.set.length == 1) {
            if (this.comparator.compare(element, this.set[0]) <= 0) {
                this.beforeFirst();
            } else {
                this.afterLast();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void after(E element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.set.length == 0) {
            return;
        }
        if (this.set.length == 1) {
            if (this.comparator.compare(element, this.set[0]) >= 0) {
                this.afterLast();
            } else {
                this.beforeFirst();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.index = -1;
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.index = this.set.length;
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        if (this.set.length > 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        if (this.set.length > 0) {
            this.index = this.set.length - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFirst() {
        return this.set.length > 0 && this.index == 0;
    }

    @Override
    public boolean isLast() {
        return this.set.length > 0 && this.index == this.set.length - 1;
    }

    @Override
    public boolean isAfterLast() {
        return this.index == this.set.length;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == -1;
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= 0) {
            --this.index;
            return true;
        }
        if (this.index <= 0) {
            this.index = -1;
            return false;
        }
        if (this.set.length <= 0) {
            this.index = -1;
        }
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        if (this.set.length > 0 && this.index == -1) {
            this.index = 0;
            return true;
        }
        if (this.set.length > 0 && this.index + 1 < this.set.length) {
            ++this.index;
            return true;
        }
        if (this.set.length > 0 && this.index + 1 == this.set.length) {
            ++this.index;
            return false;
        }
        if (this.set.length <= 0) {
            this.index = this.set.length;
        }
        return false;
    }

    @Override
    public E get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.index < 0 || this.index >= this.set.length) {
            throw new IOException(I18n.err(I18n.ERR_02009_CURSOR_NOT_POSITIONED, new Object[0]));
        }
        return this.set[this.index];
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ListCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ListCursor {}", (Object)this);
        }
        super.close(cause);
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("SetCursor :\n");
        sb.append(tabs).append("    Index : ").append(this.index).append("\n");
        if (this.set != null && this.set.length > 0) {
            sb.append(tabs).append("    Size : ").append(this.set.length).append("\n");
            int counter = 0;
            for (E e : this.set) {
                sb.append(tabs).append("    ").append(e).append("\n");
                if (++counter == 100) break;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

