/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitContentRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.LdapSyntaxRegistry;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NameFormRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.SyntaxCheckerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SchemaManager {
    public boolean load(Schema ... var1) throws LdapException;

    public boolean load(String ... var1) throws Exception;

    public boolean loadWithDeps(Schema ... var1) throws Exception;

    public boolean loadWithDeps(String ... var1) throws Exception;

    public boolean loadRelaxed(Schema ... var1) throws Exception;

    public boolean loadRelaxed(String ... var1) throws Exception;

    public boolean loadWithDepsRelaxed(Schema ... var1) throws Exception;

    public boolean loadWithDepsRelaxed(String ... var1) throws Exception;

    public boolean loadDisabled(Schema ... var1) throws Exception;

    public boolean loadDisabled(String ... var1) throws LdapException;

    public boolean loadAllEnabled() throws Exception;

    public boolean loadAllEnabledRelaxed() throws Exception;

    public boolean unload(Schema ... var1) throws Exception;

    public boolean unload(String ... var1) throws LdapException;

    public boolean enable(Schema ... var1) throws Exception;

    public boolean enable(String ... var1) throws LdapException;

    public boolean enableRelaxed(Schema ... var1);

    public boolean enableRelaxed(String ... var1);

    public List<Schema> getEnabled();

    public boolean isEnabled(String var1);

    public boolean isEnabled(Schema var1);

    public boolean disable(Schema ... var1) throws Exception;

    public boolean disable(String ... var1) throws LdapException;

    public boolean disabledRelaxed(Schema ... var1);

    public boolean disabledRelaxed(String ... var1);

    public List<Schema> getDisabled();

    public boolean isDisabled(String var1);

    public boolean isDisabled(Schema var1);

    public boolean verify(Schema ... var1) throws Exception;

    public boolean verify(String ... var1) throws Exception;

    public Registries getRegistries();

    public AttributeType lookupAttributeTypeRegistry(String var1) throws LdapException;

    public AttributeType getAttributeType(String var1);

    public LdapComparator<?> lookupComparatorRegistry(String var1) throws LdapException;

    public MatchingRule lookupMatchingRuleRegistry(String var1) throws LdapException;

    public Normalizer lookupNormalizerRegistry(String var1) throws LdapException;

    public ObjectClass lookupObjectClassRegistry(String var1) throws LdapException;

    public LdapSyntax lookupLdapSyntaxRegistry(String var1) throws LdapException;

    public SyntaxChecker lookupSyntaxCheckerRegistry(String var1) throws LdapException;

    public AttributeTypeRegistry getAttributeTypeRegistry();

    public ComparatorRegistry getComparatorRegistry();

    public DitContentRuleRegistry getDITContentRuleRegistry();

    public DitStructureRuleRegistry getDITStructureRuleRegistry();

    public MatchingRuleRegistry getMatchingRuleRegistry();

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry();

    public NormalizerRegistry getNormalizerRegistry();

    public NameFormRegistry getNameFormRegistry();

    public ObjectClassRegistry getObjectClassRegistry();

    public LdapSyntaxRegistry getLdapSyntaxRegistry();

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry();

    public Map<String, OidNormalizer> getNormalizerMapping();

    public void setRegistries(Registries var1);

    public List<Throwable> getErrors();

    public void setSchemaLoader(SchemaLoader var1);

    public Dn getNamingContext();

    public void initialize() throws Exception;

    public SchemaLoader getLoader();

    public boolean add(SchemaObject var1) throws LdapException;

    public boolean delete(SchemaObject var1) throws LdapException;

    public SchemaObject unregisterAttributeType(String var1) throws LdapException;

    public SchemaObject unregisterComparator(String var1) throws LdapException;

    public SchemaObject unregisterDitControlRule(String var1) throws LdapException;

    public SchemaObject unregisterDitStructureRule(String var1) throws LdapException;

    public SchemaObject unregisterMatchingRule(String var1) throws LdapException;

    public SchemaObject unregisterMatchingRuleUse(String var1) throws LdapException;

    public SchemaObject unregisterNameForm(String var1) throws LdapException;

    public SchemaObject unregisterNormalizer(String var1) throws LdapException;

    public SchemaObject unregisterObjectClass(String var1) throws LdapException;

    public SchemaObject unregisterLdapSyntax(String var1) throws LdapException;

    public SchemaObject unregisterSyntaxChecker(String var1) throws LdapException;

    public OidRegistry getGlobalOidRegistry();

    public Schema getLoadedSchema(String var1);

    public boolean isSchemaLoaded(String var1);

    public Set<String> listDependentSchemaNames(String var1);
}

