/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiException
extends Exception {
    static final long serialVersionUID = 2889747406899775761L;
    private Collection<Throwable> nestedExceptions = new ArrayList<Throwable>();

    public MultiException() {
    }

    public MultiException(String message) {
        super(message);
    }

    public Iterator<Throwable> listNestedExceptions() {
        return this.nestedExceptions.iterator();
    }

    public int size() {
        return this.nestedExceptions.size();
    }

    public boolean isEmpty() {
        return this.nestedExceptions.isEmpty();
    }

    public void addThrowable(Throwable nested) {
        this.nestedExceptions.add(nested);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        out.println("Nested exceptions to follow:\n");
        boolean isFirst = true;
        for (Throwable throwable : this.nestedExceptions) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.println("\n\t<<========= Next Nested Exception ========>>\n");
            }
            throwable.printStackTrace();
        }
        out.println("\n\t<<========= Last Nested Exception ========>>\n");
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        out.println("Nested exceptions to follow:\n");
        boolean isFirst = true;
        for (Throwable throwable : this.nestedExceptions) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.println("\n\t<<========= Next Nested Exception ========>>\n");
            }
            throwable.printStackTrace();
        }
        out.println("\n\t<<========= Last Nested Exception ========>>\n");
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

