/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;

public class PresenceEvaluator
implements Evaluator<PresenceNode> {
    private final PresenceNode node;
    private final Store db;
    private final AttributeType attributeType;
    private final SchemaManager schemaManager;
    private final Index<String, Entry, String> idx;

    public PresenceEvaluator(PresenceNode node, Store db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.attributeType = node.getAttributeType();
        this.idx = db.hasUserIndexOn(this.attributeType) ? db.getPresenceIndex() : null;
    }

    @Override
    public PresenceNode getExpression() {
        return this.node;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws LdapException {
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        return this.evaluate(entry);
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        if (this.db.hasSystemIndexOn(this.attributeType) || this.attributeType.getOid().equals("1.3.6.1.1.16.4")) {
            return true;
        }
        Attribute attr = entry.get(this.attributeType);
        if (attr != null) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            do {
                AttributeType descendant;
                if ((attr = entry.get(descendant = descendants.next())) == null) continue;
                return true;
            } while (descendants.hasNext());
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("PresenceEvaluator : ").append(this.node).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

