/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class KerberosTime
implements Comparable {
    public static final KerberosTime INFINITY = new KerberosTime(Long.MAX_VALUE);
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    private long kerberosTime;

    public KerberosTime() {
        this.kerberosTime = System.currentTimeMillis();
    }

    public KerberosTime(long time) {
        this.kerberosTime = time;
    }

    public KerberosTime(Date time) {
        this.kerberosTime = time.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosTime getTime(String zuluTime) throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            date = dateFormat.parse(zuluTime);
        }
        return new KerberosTime(date);
    }

    public int compareTo(Object o) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == o) {
            return 0;
        }
        KerberosTime that = (KerberosTime)o;
        if (this.kerberosTime < that.kerberosTime) {
            return -1;
        }
        if (this.kerberosTime > that.kerberosTime) {
            return 1;
        }
        return 0;
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public Date toDate() {
        return new Date(this.kerberosTime);
    }

    public boolean isInClockSkew(long clockSkew) {
        return Math.abs(this.kerberosTime - System.currentTimeMillis()) < clockSkew;
    }

    public boolean greaterThan(KerberosTime time) {
        return this.kerberosTime > time.kerberosTime;
    }

    public boolean lessThan(KerberosTime time) {
        return this.kerberosTime < time.kerberosTime;
    }

    public boolean equals(KerberosTime time) {
        return this.kerberosTime == time.kerberosTime;
    }

    public boolean isZero() {
        return this.kerberosTime == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Date kerberosDate = new Date(this.kerberosTime);
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return dateFormat.format(kerberosDate);
        }
    }

    static {
        dateFormat.setTimeZone(UTC_TIME_ZONE);
    }
}

