/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import org.apache.felix.cm.impl.ConfigurationManager;

public class UpdateThread
implements Runnable {
    private final ConfigurationManager configurationManager;
    private final ThreadGroup workerThreadGroup;
    private final String workerBaseName;
    private final LinkedList updateTasks;
    private Thread worker;
    private final AccessControlContext acc;

    public UpdateThread(ConfigurationManager configurationManager, ThreadGroup tg, String name) {
        this.configurationManager = configurationManager;
        this.workerThreadGroup = tg;
        this.workerBaseName = name;
        this.acc = AccessController.getContext();
        this.updateTasks = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable task;
            LinkedList linkedList = this.updateTasks;
            synchronized (linkedList) {
                while (this.updateTasks.isEmpty()) {
                    try {
                        this.updateTasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = (Runnable)this.updateTasks.removeFirst();
            }
            if (task == this) {
                return;
            }
            try {
                Thread.currentThread().setName(this.workerBaseName + " (" + task + ")");
                this.configurationManager.log(4, "Running task {0}", new Object[]{task});
                this.run0(task);
                continue;
            }
            catch (Throwable t) {
                this.configurationManager.log(1, "Unexpected problem executing task", t);
                continue;
            }
            finally {
                Thread.currentThread().setName(this.workerBaseName);
                continue;
            }
            break;
        }
    }

    void run0(final Runnable task) throws Throwable {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        task.run();
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        } else {
            task.run();
        }
    }

    synchronized void start() {
        if (this.worker == null) {
            Thread workerThread = new Thread(this.workerThreadGroup, this, this.workerBaseName);
            workerThread.setDaemon(true);
            workerThread.start();
            this.worker = workerThread;
        }
    }

    synchronized void terminate() {
        if (this.worker != null) {
            Thread workerThread = this.worker;
            this.worker = null;
            this.schedule(this);
            try {
                workerThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (workerThread.isAlive()) {
                this.configurationManager.log(1, "Worker thread {0} did not terminate within 5 seconds; trying to kill", new Object[]{this.workerBaseName});
                workerThread.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable update) {
        LinkedList linkedList = this.updateTasks;
        synchronized (linkedList) {
            this.configurationManager.log(4, "Scheduling task {0}", new Object[]{update});
            this.updateTasks.add(update);
            this.updateTasks.notifyAll();
        }
    }
}

