/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.runtime.ArgList;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Evaluate;
import org.apache.felix.gogo.runtime.Expander;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Pipe;
import org.apache.felix.gogo.runtime.Reflective;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Job;

public class Closure
implements Function,
Evaluate {
    public static final String LOCATION = ".location";
    public static final String PIPE_EXCEPTION = "pipe-exception";
    private static final String DEFAULT_LOCK = ".defaultLock";
    private static final ThreadLocal<String> location = new ThreadLocal();
    private final CommandSessionImpl session;
    private final Closure parent;
    private final CharSequence source;
    private final Parser.Program program;
    private final Object script;
    private Token errTok;
    private Token errTok2;
    private List<Object> parms = null;
    private List<Object> parmv = null;

    public Closure(CommandSessionImpl session, Closure parent, CharSequence source) throws Exception {
        this.session = session;
        this.parent = parent;
        this.source = source;
        this.script = session.get("0");
        if (source instanceof Parser.Program) {
            this.program = (Parser.Program)source;
        } else {
            try {
                this.program = new Parser(source).program();
            }
            catch (Exception e) {
                throw this.setLocation(e);
            }
        }
    }

    public Closure(CommandSessionImpl session, Closure parent, Parser.Program program) {
        this.session = session;
        this.parent = parent;
        this.source = program;
        this.script = session.get("0");
        this.program = program;
    }

    public CommandSessionImpl session() {
        return this.session;
    }

    private Exception setLocation(Exception e) {
        if (this.session.get(DEFAULT_LOCK) == null) {
            String loc = location.get();
            if (null == loc) {
                String string = loc = null == this.script ? "" : this.script + ":";
                if (e instanceof SyntaxError) {
                    SyntaxError se = (SyntaxError)e;
                    loc = loc + se.line() + "." + se.column();
                } else if (null != this.errTok) {
                    loc = loc + this.errTok.line + "." + this.errTok.column;
                }
                location.set(loc);
            } else if (null != this.script && !loc.contains(":")) {
                location.set(this.script + ":" + loc);
            }
            this.session.put(LOCATION, location.get());
        }
        if (e instanceof EOFError) {
            EOFException eofe = new EOFException(e.getMessage());
            eofe.initCause(e);
            return eofe;
        }
        return e;
    }

    @Override
    public Object execute(CommandSession x, List<Object> values) throws Exception {
        return this.execute(x, values, null);
    }

    public Object execute(CommandSession x, List<Object> values, Channel capturingOutput) throws Exception {
        try {
            location.remove();
            this.session.put(LOCATION, null);
            return this.execute(values, capturingOutput);
        }
        catch (Exception e) {
            throw this.setLocation(e);
        }
    }

    private Object execute(List<Object> values, Channel capturingOutput) throws Exception {
        if (null != values) {
            this.parmv = new ArrayList<Object>(values);
            this.parms = new ArgList(this.parmv);
        } else if (null != this.parent) {
            this.parmv = this.parent.parmv != null ? new ArrayList<Object>(this.parent.parmv) : null;
            this.parms = this.parmv != null ? new ArgList(this.parmv) : null;
        } else {
            Object args = this.session.get("args");
            if (null != args && args instanceof List) {
                this.parmv = new ArrayList<Object>((List)args);
                this.parms = new ArgList(this.parmv);
            }
        }
        Pipe.Result last = null;
        Parser.Operator operator = null;
        Iterator<Parser.Executable> iterator = this.program.tokens().iterator();
        while (iterator.hasNext()) {
            CommandSessionImpl.JobImpl job;
            Channel[] streams;
            Parser.Operator prevOperator = operator;
            Parser.Executable executable = iterator.next();
            operator = iterator.hasNext() ? (Parser.Operator)iterator.next() : null;
            if (prevOperator != null && (Token.eq("&&", prevOperator) ? !last.isSuccess() : Token.eq("||", prevOperator) && last.isSuccess())) continue;
            boolean[] toclose = new boolean[10];
            if (Pipe.getCurrentPipe() != null) {
                streams = (Channel[])Pipe.getCurrentPipe().streams.clone();
            } else {
                streams = new Channel[10];
                System.arraycopy(this.session.channels, 0, streams, 0, 3);
            }
            if (capturingOutput != null) {
                streams[1] = capturingOutput;
                toclose[1] = true;
            }
            if (executable instanceof Parser.Pipeline) {
                Parser.Pipeline pipeline = (Parser.Pipeline)executable;
                List<Parser.Executable> exec = pipeline.tokens();
                Token s = exec.get(0);
                Token e = exec.get(exec.size() - 1);
                Token t = this.program.subSequence(s.start - this.program.start, e.start + e.length - this.program.start);
                job = this.session().createJob(t);
                for (int i = 0; i < exec.size(); ++i) {
                    PipedOutputStream pos;
                    PipedInputStream pis;
                    boolean[] ntoclose;
                    Channel[] nstreams;
                    Parser.Operator op;
                    Parser.Statement ex = (Parser.Statement)exec.get(i);
                    Parser.Operator operator2 = op = i < exec.size() - 1 ? (Parser.Operator)exec.get(++i) : null;
                    if (i == exec.size() - 1) {
                        nstreams = streams;
                        ntoclose = toclose;
                    } else if (Token.eq("|", op)) {
                        pis = new PipedInputStream();
                        pos = new PipedOutputStream(pis);
                        nstreams = (Channel[])streams.clone();
                        nstreams[1] = Channels.newChannel(pos);
                        ntoclose = (boolean[])toclose.clone();
                        ntoclose[1] = true;
                        streams[0] = Channels.newChannel(pis);
                        toclose[0] = true;
                    } else if (Token.eq("|&", op)) {
                        pis = new PipedInputStream();
                        pos = new PipedOutputStream(pis);
                        nstreams = (Channel[])streams.clone();
                        nstreams[1] = nstreams[2] = Channels.newChannel(pos);
                        ntoclose = (boolean[])toclose.clone();
                        ntoclose[2] = true;
                        ntoclose[1] = true;
                        streams[0] = Channels.newChannel(pis);
                        toclose[0] = true;
                    } else {
                        throw new IllegalStateException("Unrecognized pipe operator: '" + op + "'");
                    }
                    Pipe pipe = new Pipe(this, job, ex, nstreams, ntoclose);
                    job.addPipe(pipe);
                }
            } else {
                job = this.session().createJob(executable);
                Pipe pipe = new Pipe(this, job, (Parser.Statement)executable, streams, toclose);
                job.addPipe(pipe);
            }
            if (operator != null && Token.eq("&", operator)) {
                job.start(Job.Status.Background);
                last = new Pipe.Result((Object)null);
                continue;
            }
            last = job.start(Job.Status.Foreground);
            if (last == null) {
                last = new Pipe.Result((Object)null);
                continue;
            }
            if (last.exception == null) continue;
            throw last.exception;
        }
        return last == null ? null : last.result;
    }

    private Object eval(Object v) {
        String s = v.toString();
        if ("null".equals(s)) {
            v = null;
        } else if ("false".equals(s)) {
            v = false;
        } else if ("true".equals(s)) {
            v = true;
        } else {
            try {
                v = s;
                v = Double.parseDouble(s);
                v = Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return v;
    }

    @Override
    public Object eval(Token t) throws Exception {
        if (t instanceof Parser.Closure) {
            return new Closure(this.session, this, ((Parser.Closure)t).program());
        }
        if (t instanceof Parser.Sequence) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WritableByteChannel out = Channels.newChannel(baos);
            Object result = new Closure(this.session, this, ((Parser.Sequence)t).program()).execute(this.session, this.parms, out);
            if (result != null) {
                return result;
            }
            String s = baos.toString();
            while (!s.isEmpty() && s.charAt(s.length() - 1) == '\n') {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
        if (t instanceof Parser.Array) {
            return this.array((Parser.Array)t);
        }
        Object v = Expander.expand(t, this);
        if (t == v) {
            v = this.eval(v);
        }
        return v;
    }

    public Object execute(Parser.Executable executable) throws Exception {
        if (executable instanceof Parser.Statement) {
            return this.executeStatement((Parser.Statement)executable);
        }
        if (executable instanceof Parser.Sequence) {
            return new Closure(this.session, this, ((Parser.Sequence)executable).program()).execute(new ArrayList<Object>(), null);
        }
        throw new IllegalStateException();
    }

    public Object executeStatement(Parser.Statement statement) throws Exception {
        List<Token> tokens;
        Object echo = this.session.get("echo");
        String xtrace = null;
        if (echo != null && !"false".equals(echo.toString())) {
            xtrace = "+" + statement;
            this.session.perr.println(xtrace);
        }
        if ((tokens = statement.tokens()).isEmpty()) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        this.errTok = tokens.get(0);
        if (tokens.size() > 3 && Token.eq("=", tokens.get(1))) {
            this.errTok2 = tokens.get(2);
        }
        for (Token t : tokens) {
            Object v = this.eval(t);
            if (v instanceof ArgList) {
                values.addAll((ArgList)v);
                continue;
            }
            values.add(v);
        }
        Object cmd = values.remove(0);
        if (cmd == null) {
            if (values.isEmpty()) {
                return null;
            }
            throw new RuntimeException("Command name evaluates to null: " + this.errTok);
        }
        if (cmd instanceof CharSequence && values.size() > 0 && Token.eq("=", tokens.get(1))) {
            Object value;
            values.remove(0);
            String scmd = cmd.toString();
            if (values.size() == 0) {
                return this.session.put(scmd, null);
            }
            if (values.size() == 1) {
                value = values.get(0);
            } else {
                cmd = values.remove(0);
                if (null == cmd) {
                    throw new RuntimeException("Command name evaluates to null: " + this.errTok2);
                }
                this.trace2(xtrace, cmd, values);
                value = this.bareword(tokens.get(2), cmd) ? this.executeCmd(cmd.toString(), values) : this.executeMethod(cmd, values);
            }
            return this.assignment(scmd, value);
        }
        this.trace2(xtrace, cmd, values);
        return this.bareword(tokens.get(0), cmd) ? this.executeCmd(cmd.toString(), values) : this.executeMethod(cmd, values);
    }

    private void trace2(String trace1, Object cmd, List<Object> values) {
        if ("verbose".equals(this.session.get("echo"))) {
            StringBuilder buf = new StringBuilder("+ " + cmd);
            for (Object value : values) {
                buf.append(' ');
                buf.append(value);
            }
            String trace2 = buf.toString();
            if (!trace2.equals(trace1)) {
                this.session.perr.println("+" + trace2);
            }
        }
    }

    private boolean bareword(Token t, Object v) throws Exception {
        return v instanceof CharSequence && Token.eq(t, (CharSequence)v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeCmd(String scmd, List<Object> values) throws Exception {
        String scopedFunction = scmd;
        Object x = this.get(scmd);
        if (!(x instanceof Function)) {
            if (scmd.indexOf(58) < 0) {
                scopedFunction = "*:" + scmd;
            }
            if ((x = this.get(scopedFunction)) == null || !(x instanceof Function)) {
                if (this.session.get(DEFAULT_LOCK) == null) {
                    x = this.get("default");
                    if (x == null) {
                        x = this.get("*:default");
                    }
                    if (x instanceof Function) {
                        try {
                            this.session.put(DEFAULT_LOCK, true);
                            values.add(0, scmd);
                            Object object = ((Function)x).execute(this.session, values);
                            return object;
                        }
                        finally {
                            this.session.put(DEFAULT_LOCK, null);
                        }
                    }
                }
                throw new CommandNotFoundException(scmd);
            }
        }
        return ((Function)x).execute(this.session, values);
    }

    private Object executeMethod(Object cmd, List<Object> values) throws Exception {
        boolean dot;
        if (values.isEmpty()) {
            return cmd;
        }
        boolean bl = dot = values.size() > 1 && ".".equals(String.valueOf(values.get(0)));
        if (dot) {
            Object target = cmd;
            ArrayList<Object> args = new ArrayList<Object>();
            values.remove(0);
            for (Object arg : values) {
                if (".".equals(arg)) {
                    target = Reflective.invoke(this.session, target, args.remove(0).toString(), args);
                    args.clear();
                    continue;
                }
                args.add(arg);
            }
            if (args.size() == 0) {
                return target;
            }
            return Reflective.invoke(this.session, target, args.remove(0).toString(), args);
        }
        if (cmd.getClass().isArray() && values.size() == 1) {
            Object[] cmdv = (Object[])cmd;
            String index = values.get(0).toString();
            return "length".equals(index) ? Integer.valueOf(cmdv.length) : cmdv[Integer.parseInt(index)];
        }
        return Reflective.invoke(this.session, cmd, values.remove(0).toString(), values);
    }

    private Object assignment(String name, Object value) {
        this.session.put(name, value);
        return value;
    }

    @Override
    public Object expr(Token expr) {
        return this.session.expr(expr);
    }

    private Object array(Parser.Array array) throws Exception {
        List<Token> list = array.list();
        Map<Token, Token> map = array.map();
        if (list != null) {
            ArrayList<Object> olist = new ArrayList<Object>();
            for (Token t : list) {
                Object oval = this.eval(t);
                if (oval.getClass().isArray()) {
                    Collections.addAll(olist, (Object[])oval);
                    continue;
                }
                olist.add(oval);
            }
            return olist;
        }
        LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Token, Token> e : map.entrySet()) {
            Token key = e.getKey();
            Object k = this.eval(key);
            if (!(k instanceof String)) {
                throw new SyntaxError(key.line(), key.column(), "map key null or not String: " + key);
            }
            omap.put(k, this.eval(e.getValue()));
        }
        return omap;
    }

    @Override
    public Object get(String name) {
        if (this.parms != null) {
            int i;
            if ("args".equals(name)) {
                return this.parms;
            }
            if ("argv".equals(name)) {
                return this.parmv;
            }
            if ("it".equals(name)) {
                return this.parms.get(0);
            }
            if (name.length() == 1 && Character.isDigit(name.charAt(0)) && (i = name.charAt(0) - 48) > 0) {
                return this.parms.get(i - 1);
            }
        }
        return this.session.get(name);
    }

    @Override
    public Object put(String key, Object value) {
        return this.session.put(key, value);
    }

    @Override
    public Path currentDir() {
        return this.isSet("gogo.option.noglob", false) ? null : this.session().currentDir();
    }

    protected boolean isSet(String name, boolean def) {
        Object v = this.session.get(name);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v != null) {
            String s = v.toString();
            return s.isEmpty() || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("true");
        }
        return def;
    }

    public String toString() {
        return this.source.toString().trim().replaceAll("\n+", "\n").replaceAll("([^\\\\{}(\\[])[\\s\n]*\n", "$1;").replaceAll("[ \\\\\t\n]+", " ");
    }
}

