/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AvroSchemaConverter {
    private AvroSchemaConverter() {
    }

    public static <T extends SpecificRecord> TypeInformation<Row> convertToTypeInfo(Class<T> avroClass) {
        Preconditions.checkNotNull(avroClass, (String)"Avro specific record class must not be null.");
        Schema schema = SpecificData.get().getSchema(avroClass);
        return AvroSchemaConverter.convertToTypeInfo(schema);
    }

    public static <T> TypeInformation<T> convertToTypeInfo(String avroSchemaString) {
        Schema schema;
        Preconditions.checkNotNull((Object)avroSchemaString, (String)"Avro schema must not be null.");
        try {
            schema = new Schema.Parser().parse(avroSchemaString);
        }
        catch (SchemaParseException e) {
            throw new IllegalArgumentException("Could not parse Avro schema string.", e);
        }
        return AvroSchemaConverter.convertToTypeInfo(schema);
    }

    private static TypeInformation<?> convertToTypeInfo(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                List fields = schema.getFields();
                TypeInformation[] types = new TypeInformation[fields.size()];
                String[] names = new String[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field = (Schema.Field)fields.get(i);
                    types[i] = AvroSchemaConverter.convertToTypeInfo(field.schema());
                    names[i] = field.name();
                }
                return Types.ROW_NAMED((String[])names, (TypeInformation[])types);
            }
            case ENUM: {
                return Types.STRING;
            }
            case ARRAY: {
                return Types.OBJECT_ARRAY(AvroSchemaConverter.convertToTypeInfo(schema.getElementType()));
            }
            case MAP: {
                return Types.MAP((TypeInformation)Types.STRING, AvroSchemaConverter.convertToTypeInfo(schema.getValueType()));
            }
            case UNION: {
                Schema actualSchema;
                if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(1);
                } else if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                } else if (schema.getTypes().size() == 1) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                } else {
                    return Types.GENERIC(Object.class);
                }
                return AvroSchemaConverter.convertToTypeInfo(actualSchema);
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return Types.BIG_DEC;
                }
                return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
            }
            case STRING: {
                return Types.STRING;
            }
            case BYTES: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return Types.BIG_DEC;
                }
                return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
            }
            case INT: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType == LogicalTypes.date()) {
                    return Types.SQL_DATE;
                }
                if (logicalType == LogicalTypes.timeMillis()) {
                    return Types.SQL_TIME;
                }
                return Types.INT;
            }
            case LONG: {
                if (schema.getLogicalType() == LogicalTypes.timestampMillis()) {
                    return Types.SQL_TIMESTAMP;
                }
                return Types.LONG;
            }
            case FLOAT: {
                return Types.FLOAT;
            }
            case DOUBLE: {
                return Types.DOUBLE;
            }
            case BOOLEAN: {
                return Types.BOOLEAN;
            }
            case NULL: {
                return Types.VOID;
            }
        }
        throw new IllegalArgumentException("Unsupported Avro type '" + schema.getType() + "'.");
    }
}

