/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.application.EmbeddedJobClient;
import org.apache.flink.client.deployment.application.executors.EmbeddedExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.Preconditions;

@Internal
public class EmbeddedExecutorFactory
implements PipelineExecutorFactory {
    private final Collection<JobID> submittedJobIds;
    private final DispatcherGateway dispatcherGateway;
    private final ScheduledExecutor retryExecutor;

    public EmbeddedExecutorFactory(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway, ScheduledExecutor retryExecutor) {
        this.submittedJobIds = (Collection)Preconditions.checkNotNull(submittedJobIds);
        this.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
        this.retryExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)retryExecutor);
    }

    public String getName() {
        return "embedded";
    }

    public boolean isCompatibleWith(Configuration configuration) {
        return false;
    }

    public PipelineExecutor getExecutor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return new EmbeddedExecutor(this.submittedJobIds, this.dispatcherGateway, (jobId, userCodeClassloader) -> {
            Time timeout = Time.milliseconds((long)((Duration)configuration.get(ClientOptions.CLIENT_TIMEOUT)).toMillis());
            return new EmbeddedJobClient(jobId, this.dispatcherGateway, this.retryExecutor, timeout, userCodeClassloader);
        });
    }
}

