/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterRetrieveException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.StandaloneClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FlinkException;

public class LegacyStandaloneClusterDescriptor
implements ClusterDescriptor<StandaloneClusterId> {
    private final Configuration config;

    public LegacyStandaloneClusterDescriptor(Configuration config) {
        this.config = config;
    }

    @Override
    public String getClusterDescription() {
        String host = this.config.getString(JobManagerOptions.ADDRESS, "");
        int port = this.config.getInteger(JobManagerOptions.PORT, -1);
        return "Standalone cluster at " + host + ":" + port;
    }

    public StandaloneClusterClient retrieve(StandaloneClusterId standaloneClusterId) throws ClusterRetrieveException {
        try {
            return new StandaloneClusterClient(this.config);
        }
        catch (Exception e) {
            throw new ClusterRetrieveException("Couldn't retrieve standalone cluster", e);
        }
    }

    public StandaloneClusterClient deploySessionCluster(ClusterSpecification clusterSpecification) {
        throw new UnsupportedOperationException("Can't deploy a standalone cluster.");
    }

    public StandaloneClusterClient deployJobCluster(ClusterSpecification clusterSpecification, JobGraph jobGraph, boolean detached) {
        throw new UnsupportedOperationException("Can't deploy a standalone per-job cluster.");
    }

    @Override
    public void killCluster(StandaloneClusterId clusterId) throws FlinkException {
        throw new UnsupportedOperationException("Cannot terminate standalone clusters.");
    }

    @Override
    public void close() throws Exception {
    }
}

