/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.FlinkPlan;

public class OptimizerPlanEnvironment
extends ExecutionEnvironment {
    private final Optimizer compiler;
    private FlinkPlan optimizerPlan;

    public OptimizerPlanEnvironment(Optimizer compiler) {
        this.compiler = compiler;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        Plan plan = this.createProgramPlan(jobName);
        this.optimizerPlan = this.compiler.compile(plan);
        throw new ProgramAbortException();
    }

    public String getExecutionPlan() throws Exception {
        Plan plan = this.createProgramPlan(null, false);
        this.optimizerPlan = this.compiler.compile(plan);
        throw new ProgramAbortException();
    }

    public void startNewSession() {
    }

    public FlinkPlan getOptimizedPlan(PackagedProgram prog) throws ProgramInvocationException {
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ByteArrayOutputStream baes = new ByteArrayOutputStream();
        System.setErr(new PrintStream(baes));
        this.setAsContext();
        try {
            prog.invokeInteractiveModeForExecution();
        }
        catch (ProgramInvocationException e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.optimizerPlan != null) {
                FlinkPlan flinkPlan = this.optimizerPlan;
                return flinkPlan;
            }
            throw new ProgramInvocationException("The program caused an error: ", t);
        }
        finally {
            this.unsetAsContext();
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        String stdout = baos.toString();
        String stderr = baes.toString();
        throw new ProgramInvocationException("The program plan could not be fetched - the program aborted pre-maturely.\n\nSystem.err: " + (stdout.length() == 0 ? "(none)" : stdout) + "\n\nSystem.out: " + (stderr.length() == 0 ? "(none)" : stderr));
    }

    private void setAsContext() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                return OptimizerPlanEnvironment.this;
            }
        };
        OptimizerPlanEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    private void unsetAsContext() {
        OptimizerPlanEnvironment.resetContextEnvironment();
    }

    public void setPlan(FlinkPlan plan) {
        this.optimizerPlan = plan;
    }

    public static final class ProgramAbortException
    extends Error {
        private static final long serialVersionUID = 1L;
    }
}

