/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.changelog.fs.StateChangeSet;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.util.Preconditions;

@Internal
public final class UploadResult {
    public final StreamStateHandle streamStateHandle;
    @Nullable
    public final StreamStateHandle localStreamHandle;
    public final long offset;
    public final long localOffset;
    public final SequenceNumber sequenceNumber;
    public final long size;

    public UploadResult(StreamStateHandle streamStateHandle, long offset, SequenceNumber sequenceNumber, long size) {
        this(streamStateHandle, null, offset, offset, sequenceNumber, size);
    }

    public UploadResult(StreamStateHandle streamStateHandle, @Nullable StreamStateHandle localStreamHandle, long offset, long localOffset, SequenceNumber sequenceNumber, long size) {
        this.streamStateHandle = (StreamStateHandle)Preconditions.checkNotNull((Object)streamStateHandle);
        this.localStreamHandle = localStreamHandle;
        this.offset = offset;
        this.localOffset = localOffset;
        this.sequenceNumber = (SequenceNumber)Preconditions.checkNotNull((Object)sequenceNumber);
        this.size = size;
    }

    public static UploadResult of(StreamStateHandle handle, StreamStateHandle localHandle, StateChangeSet changeSet, long offset, long localOffset) {
        return new UploadResult(handle, localHandle, offset, localOffset, changeSet.getSequenceNumber(), changeSet.getSize());
    }

    public StreamStateHandle getStreamStateHandle() {
        return this.streamStateHandle;
    }

    public StreamStateHandle getLocalStreamHandleStateHandle() {
        return this.localStreamHandle;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLocalOffset() {
        return this.localOffset;
    }

    public SequenceNumber getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "streamStateHandle=" + this.streamStateHandle + "localStreamHandle" + this.localStreamHandle + ", size=" + this.size + ", offset=" + this.offset + ", sequenceNumber=" + this.sequenceNumber;
    }
}

